/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.htl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.sling.scripting.sightly.compiler.CompilationResult;
import org.apache.sling.scripting.sightly.compiler.CompilationUnit;
import org.apache.sling.scripting.sightly.compiler.CompilerMessage;
import org.apache.sling.scripting.sightly.compiler.SightlyCompiler;
import org.codehaus.plexus.util.Scanner;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="validate", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true)
public class ValidateMojo
extends AbstractMojo {
    private static final String DEFAULT_INCLUDES = "**/*.html";
    private static final String DEFAULT_EXCLUDES = "";
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="sourceDirectory", defaultValue="${project.build.sourceDirectory}")
    private File sourceDirectory;
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter(property="failOnWarnings", defaultValue="false")
    private boolean failOnWarnings;
    @Parameter(property="htl.skip", defaultValue="false")
    private boolean skip;
    private boolean hasWarnings = false;
    private boolean hasErrors = false;
    private String processedIncludes = null;
    private String processedExcludes = null;
    private List<File> processedFiles = Collections.emptyList();
    private int sourceDirectoryLength = 0;

    /*
     * WARNING - void declaration
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping validation.");
            return;
        }
        long start = System.currentTimeMillis();
        if (!this.sourceDirectory.isAbsolute()) {
            this.sourceDirectory = new File(this.project.getBasedir(), this.sourceDirectory.getPath());
        }
        if (!this.sourceDirectory.exists()) {
            this.getLog().info((CharSequence)"Source directory does not exist, skipping.");
            return;
        }
        if (!this.sourceDirectory.isDirectory()) {
            throw new MojoExecutionException(String.format("Configured sourceDirectory={%s} is not a directory.", this.sourceDirectory.getAbsolutePath()));
        }
        if (!this.buildContext.hasDelta(this.sourceDirectory)) {
            this.getLog().info((CharSequence)"No files found to validate, skipping.");
            return;
        }
        boolean mayFailExecution = !this.buildContext.getClass().getName().startsWith("org.eclipse.m2e");
        this.sourceDirectoryLength = this.sourceDirectory.getAbsolutePath().length();
        this.processedIncludes = this.processIncludes();
        this.processedExcludes = this.processExcludes();
        try {
            void var9_11;
            SightlyCompiler compiler = new SightlyCompiler();
            Scanner scanner = this.buildContext.newScanner(this.sourceDirectory);
            scanner.setExcludes(new String[]{this.processedExcludes});
            scanner.setIncludes(new String[]{this.processedIncludes});
            scanner.scan();
            String[] includedFiles = scanner.getIncludedFiles();
            this.processedFiles = new ArrayList<File>(includedFiles.length);
            String[] stringArray = includedFiles;
            int n = stringArray.length;
            boolean bl = false;
            while (var9_11 < n) {
                String includedFile = stringArray[var9_11];
                this.processedFiles.add(new File(this.sourceDirectory, includedFile));
                ++var9_11;
            }
            HashMap<File, CompilationResult> compilationResults = new HashMap<File, CompilationResult>();
            for (File file : this.processedFiles) {
                compilationResults.put(file, compiler.compile(this.getCompilationUnit(file)));
            }
            for (Map.Entry entry : compilationResults.entrySet()) {
                File script = (File)entry.getKey();
                CompilationResult result = (CompilationResult)entry.getValue();
                this.buildContext.removeMessages(script);
                if (result.getWarnings().size() > 0) {
                    for (CompilerMessage message : result.getWarnings()) {
                        this.buildContext.addMessage(script, message.getLine(), message.getColumn(), message.getMessage(), 1, null);
                    }
                    this.hasWarnings = true;
                }
                if (result.getErrors().size() <= 0) continue;
                for (CompilerMessage message : result.getErrors()) {
                    String messageString = message.getMessage().replaceAll(System.lineSeparator(), DEFAULT_EXCLUDES);
                    this.buildContext.addMessage(script, message.getLine(), message.getColumn(), messageString, 2, null);
                }
                this.hasErrors = true;
            }
            this.getLog().info((CharSequence)("Processed " + this.processedFiles.size() + " files in " + (System.currentTimeMillis() - start) + " milliseconds"));
            if (mayFailExecution && this.hasWarnings && this.failOnWarnings) {
                throw new MojoFailureException("Compilation warnings were configured to fail the build.");
            }
            if (mayFailExecution && this.hasErrors) {
                throw new MojoFailureException("Please check the reported syntax errors.");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Cannot filter files from {%s} with includes {%s} and excludes {%s}.", this.sourceDirectory.getAbsolutePath(), this.processedIncludes, this.processedExcludes), (Exception)e);
        }
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public boolean shouldFailOnWarnings() {
        return this.failOnWarnings;
    }

    public boolean hasWarnings() {
        return this.hasWarnings;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public String getIncludes() {
        return this.processedIncludes;
    }

    public String getExcludes() {
        return this.processedExcludes;
    }

    public List<File> getProcessedFiles() {
        return this.processedFiles;
    }

    private String processIncludes() {
        if (this.includes == null) {
            return DEFAULT_INCLUDES;
        }
        return this.join(this.includes, ',');
    }

    private String processExcludes() {
        if (this.excludes == null) {
            return DEFAULT_EXCLUDES;
        }
        return this.join(this.excludes, ',');
    }

    private String join(String[] array, char joinChar) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int index = 0; index < array.length; ++index) {
            stringBuilder.append(StringUtils.trim((String)array[index]));
            if (index >= array.length - 1) continue;
            stringBuilder.append(joinChar);
        }
        return stringBuilder.toString();
    }

    private CompilationUnit getCompilationUnit(final File file) throws FileNotFoundException {
        final FileReader reader = new FileReader(file);
        return new CompilationUnit(){

            public String getScriptName() {
                return file.getAbsolutePath().substring(ValidateMojo.this.sourceDirectoryLength);
            }

            public Reader getScriptReader() {
                return reader;
            }
        };
    }

    void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }
}

