/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.htl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.htl.compiler.HTLClassInfo;
import org.apache.sling.maven.htl.compiler.HTLJavaImportsAnalyzer;
import org.apache.sling.maven.htl.compiler.ScriptCompilationUnit;
import org.apache.sling.scripting.sightly.compiler.CompilationResult;
import org.apache.sling.scripting.sightly.compiler.CompilationUnit;
import org.apache.sling.scripting.sightly.compiler.CompilerMessage;
import org.apache.sling.scripting.sightly.compiler.SightlyCompiler;
import org.apache.sling.scripting.sightly.compiler.backend.BackendCompiler;
import org.apache.sling.scripting.sightly.java.compiler.ClassInfo;
import org.apache.sling.scripting.sightly.java.compiler.JavaClassBackendCompiler;
import org.apache.sling.scripting.sightly.java.compiler.JavaImportsAnalyzer;
import org.codehaus.plexus.util.Scanner;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="validate", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true)
public class ValidateMojo
extends AbstractMojo {
    private static final String DEFAULT_INCLUDES = "**/*.html";
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="htl.sourceDirectory", defaultValue="${project.build.scriptSourceDirectory}")
    private File sourceDirectory;
    @Parameter(defaultValue="**/*.html")
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter(property="htl.failOnWarnings", defaultValue="false")
    private boolean failOnWarnings;
    @Parameter(property="htl.failOnErrors", defaultValue="true")
    private boolean failOnErrors;
    @Parameter(property="htl.generateJavaClasses", defaultValue="false")
    private boolean generateJavaClasses;
    @Parameter(property="htl.generatedJavaClassesDirectory", defaultValue="${project.build.directory}/generated-sources/htl")
    private File generatedJavaClassesDirectory;
    @Parameter(property="htl.generatedJavaClassesPrefix")
    private String generatedJavaClassesPrefix;
    @Parameter(property="htl.ignoreImports")
    private Set<String> ignoreImports;
    @Parameter(property="htl.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="htl.allowedExpressionOptions")
    private Set<String> allowedExpressionOptions;
    private boolean hasWarnings = false;
    private boolean hasErrors = false;
    private List<File> processedFiles = Collections.emptyList();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping validation.");
            return;
        }
        long start = System.currentTimeMillis();
        if (!this.sourceDirectory.isAbsolute()) {
            this.sourceDirectory = new File(this.project.getBasedir(), this.sourceDirectory.getPath());
        }
        if (!this.sourceDirectory.exists()) {
            this.getLog().info((CharSequence)"Source directory does not exist, skipping.");
            return;
        }
        if (!this.sourceDirectory.isDirectory()) {
            throw new MojoExecutionException(String.format("Configured sourceDirectory={%s} is not a directory.", this.sourceDirectory.getAbsolutePath()));
        }
        if (this.generateJavaClasses) {
            if (!this.generatedJavaClassesDirectory.isAbsolute()) {
                this.generatedJavaClassesDirectory = new File(this.project.getBasedir(), this.generatedJavaClassesDirectory.getPath());
            }
            if (this.generatedJavaClassesDirectory.exists() && !this.generatedJavaClassesDirectory.isDirectory()) {
                throw new MojoExecutionException(String.format("Configured generatedJavaClassesDirectory={%s} is not a directory.", this.generatedJavaClassesDirectory.getAbsolutePath()));
            }
            if (!this.generatedJavaClassesDirectory.exists() && !this.generatedJavaClassesDirectory.mkdirs()) {
                throw new MojoExecutionException(String.format("Unable to generate generatedJavaClassesDirectory={%s}.", this.generatedJavaClassesDirectory.getAbsolutePath()));
            }
            this.project.addCompileSourceRoot(this.generatedJavaClassesDirectory.getPath());
        }
        if (!this.buildContext.hasDelta(this.sourceDirectory)) {
            this.getLog().info((CharSequence)"No files found to validate, skipping.");
            return;
        }
        boolean mayFailExecution = !this.buildContext.getClass().getName().startsWith("org.eclipse.m2e");
        try {
            Scanner scanner = this.buildContext.newScanner(this.sourceDirectory);
            scanner.setExcludes(this.excludes);
            scanner.setIncludes(this.includes);
            scanner.scan();
            String[] includedFiles = scanner.getIncludedFiles();
            this.processedFiles = new ArrayList<File>(includedFiles.length);
            for (String includedFile : includedFiles) {
                this.processedFiles.add(new File(this.sourceDirectory, includedFile));
            }
            SightlyCompiler compiler = SightlyCompiler.withKnownExpressionOptions(this.allowedExpressionOptions);
            Map<File, CompilationResult> compilationResults = this.generateJavaClasses ? this.transpileHTLScriptsToJavaClasses(this.processedFiles, compiler, new HTLJavaImportsAnalyzer(this.ignoreImports)) : this.compileHTLScripts(this.processedFiles, compiler);
            for (Map.Entry<File, CompilationResult> entry : compilationResults.entrySet()) {
                File script = entry.getKey();
                CompilationResult result = entry.getValue();
                this.buildContext.removeMessages(script);
                if (result.getWarnings().size() > 0) {
                    for (CompilerMessage message : result.getWarnings()) {
                        this.buildContext.addMessage(script, message.getLine(), message.getColumn(), message.getMessage(), 1, null);
                    }
                    this.hasWarnings = true;
                }
                if (result.getErrors().size() <= 0) continue;
                for (CompilerMessage message : result.getErrors()) {
                    String messageString = message.getMessage().replaceAll(System.lineSeparator(), "");
                    this.buildContext.addMessage(script, message.getLine(), message.getColumn(), messageString, 2, null);
                }
                this.hasErrors = true;
            }
            this.getLog().info((CharSequence)("Processed " + this.processedFiles.size() + " files in " + (System.currentTimeMillis() - start) + "ms"));
            if (mayFailExecution && this.hasWarnings && this.failOnWarnings) {
                throw new MojoFailureException("Compilation warnings were configured to fail the build.");
            }
            if (mayFailExecution && this.hasErrors && this.failOnErrors) {
                throw new MojoFailureException("Please check the reported syntax errors.");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Cannot filter files from {%s} with includes {%s} and excludes {%s}.", this.sourceDirectory.getAbsolutePath(), Arrays.asList(this.includes), Arrays.asList(this.excludes)), (Exception)e);
        }
    }

    private Map<File, CompilationResult> transpileHTLScriptsToJavaClasses(List<File> scripts, SightlyCompiler compiler, JavaImportsAnalyzer javaImportsAnalyzer) throws IOException {
        LinkedHashMap<File, CompilationResult> compilationResult = new LinkedHashMap<File, CompilationResult>(scripts.size());
        for (File script : scripts) {
            JavaClassBackendCompiler backendCompiler = new JavaClassBackendCompiler(javaImportsAnalyzer);
            ScriptCompilationUnit compilationUnit = new ScriptCompilationUnit(this.sourceDirectory, script);
            compilationResult.put(script, compiler.compile((CompilationUnit)compilationUnit, (BackendCompiler)backendCompiler));
            File scriptFile = new File(script.getPath());
            File sourceDirectoryDir = new File(this.sourceDirectory.getAbsolutePath());
            String shortenedScriptPath = StringUtils.substringAfter((String)scriptFile.getCanonicalPath(), (String)sourceDirectoryDir.getCanonicalPath());
            HTLClassInfo classInfo = StringUtils.isNotEmpty((CharSequence)this.generatedJavaClassesPrefix) ? new HTLClassInfo(this.generatedJavaClassesPrefix, shortenedScriptPath) : new HTLClassInfo(shortenedScriptPath);
            String javaSourceCode = backendCompiler.build((ClassInfo)classInfo);
            File generatedClassFile = new File(this.generatedJavaClassesDirectory, classInfo.getFullyQualifiedClassName().replaceAll("\\.", Matcher.quoteReplacement(File.separator)) + ".java");
            FileUtils.forceMkdirParent((File)generatedClassFile);
            IOUtils.write((String)javaSourceCode, (OutputStream)new FileOutputStream(generatedClassFile), (Charset)StandardCharsets.UTF_8);
            compilationUnit.dispose();
        }
        return compilationResult;
    }

    private Map<File, CompilationResult> compileHTLScripts(List<File> scripts, SightlyCompiler compiler) throws IOException {
        LinkedHashMap<File, CompilationResult> compilationResult = new LinkedHashMap<File, CompilationResult>(scripts.size());
        for (File script : scripts) {
            ScriptCompilationUnit scriptCompilationUnit = new ScriptCompilationUnit(this.sourceDirectory, script);
            compilationResult.put(script, compiler.compile((CompilationUnit)scriptCompilationUnit));
            scriptCompilationUnit.dispose();
        }
        return compilationResult;
    }

    void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    boolean hasWarnings() {
        return this.hasWarnings;
    }

    boolean hasErrors() {
        return this.hasErrors;
    }

    List<File> getProcessedFiles() {
        return this.processedFiles;
    }
}

