/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.enforcer;

import java.text.ChoiceFormat;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.maven.enforcer.rule.api.EnforcerRule2;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.InputLocation;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class RequireExplicitDependencyScope
extends AbstractNonCacheableEnforcerRule
implements EnforcerRule2 {
    public void execute(@Nonnull EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            int numMissingDependencyScopes = 0;
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            if (project == null) {
                throw new ExpressionEvaluationException("${project} is null");
            }
            List dependencies = project.getOriginalModel().getDependencies();
            for (Dependency dependency : dependencies) {
                helper.getLog().debug((CharSequence)("Found dependency " + dependency));
                if (dependency.getScope() != null) continue;
                MessageBuilder msgBuilder = MessageUtils.buffer();
                helper.getLog().warn((CharSequence)msgBuilder.a((CharSequence)"Dependency ").strong((Object)dependency.getManagementKey()).a((CharSequence)" @ ").strong((Object)RequireExplicitDependencyScope.formatLocation(dependency.getLocation((Object)""))).a((CharSequence)" does not have an explicit scope defined!").toString());
                ++numMissingDependencyScopes;
            }
            if (numMissingDependencyScopes > 0) {
                ChoiceFormat scopesFormat = new ChoiceFormat("1#scope|1<scopes");
                throw new EnforcerRuleException("Found " + numMissingDependencyScopes + " missing dependency " + scopesFormat.format(numMissingDependencyScopes) + ". Look at the warnings emitted above for the details.");
            }
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Cannot resolve expression: " + eee.getCause(), (Exception)((Object)eee));
        }
    }

    protected static String formatLocation(InputLocation location) {
        StringBuilder buffer = new StringBuilder();
        if (location.getLineNumber() > 0) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("line ").append(location.getLineNumber());
        }
        if (location.getColumnNumber() > 0) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("column ").append(location.getColumnNumber());
        }
        return buffer.toString();
    }
}

