/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.enforcer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ChoiceFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.enforcer.rule.api.EnforcerRule2;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import org.eclipse.aether.util.graph.selector.StaticDependencySelector;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;

public class RequireProvidedDependenciesInRuntimeClasspath
extends AbstractNonCacheableEnforcerRule
implements EnforcerRule2 {
    private List<String> excludes = null;
    private boolean includeOptionals = false;
    private boolean includeDirects = false;

    public void execute(@Nonnull EnforcerRuleHelper helper) throws EnforcerRuleException {
        RepositorySystem repoSystem;
        List remoteRepositories;
        DefaultRepositorySystemSession newRepoSession;
        MavenProject project;
        try {
            project = (MavenProject)helper.evaluate("${project}");
            if (project == null) {
                throw new ExpressionEvaluationException("${project} is null");
            }
            RepositorySystemSession repoSession = (RepositorySystemSession)helper.evaluate("${repositorySystemSession}");
            if (repoSession == null) {
                throw new ExpressionEvaluationException("${repositorySystemSession} is null");
            }
            newRepoSession = new DefaultRepositorySystemSession(repoSession);
            remoteRepositories = (List)helper.evaluate("${project.remoteProjectRepositories}");
            repoSystem = (RepositorySystem)helper.getComponent(RepositorySystem.class);
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Cannot resolve expression: " + eee.getCause(), (Exception)((Object)eee));
        }
        catch (ComponentLookupException cle) {
            throw new EnforcerRuleException("Unable to retrieve component RepositorySystem", (Exception)((Object)cle));
        }
        Log log = helper.getLog();
        ArrayList<Object> depSelectors = new ArrayList<Object>();
        depSelectors.add(new ScopeDependencySelector(new String[]{"test"}));
        if (this.excludes != null && !this.excludes.isEmpty()) {
            Collection exclusions = this.excludes.stream().map(RequireProvidedDependenciesInRuntimeClasspath::convertPatternToExclusion).collect(Collectors.toCollection(LinkedList::new));
            exclusions.add(new Exclusion("*", "*", "*", "pom"));
            depSelectors.add(new ExclusionDependencySelector(exclusions));
        }
        if (!this.includeOptionals) {
            depSelectors.add(new OptionalDependencySelector());
        }
        if (!this.includeDirects) {
            depSelectors.add(new LevelAndScopeExclusionSelector(1, "provided"));
        }
        newRepoSession.setDependencySelector((DependencySelector)new AndDependencySelector(depSelectors));
        List<org.eclipse.aether.artifact.Artifact> runtimeArtifacts = project.getRuntimeArtifacts().stream().map(RepositoryUtils::toArtifact).collect(Collectors.toList());
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Collected " + runtimeArtifacts.size() + " runtime dependencies "));
            for (org.eclipse.aether.artifact.Artifact runtimeArtifact : runtimeArtifacts) {
                log.debug((CharSequence)runtimeArtifact.toString());
            }
        }
        Dependency rootDependency = RepositoryUtils.toDependency((Artifact)project.getArtifact(), null);
        try {
            DependencyNode rootDependencyNode = this.collectTransitiveDependencies(rootDependency, repoSystem, (RepositorySystemSession)newRepoSession, remoteRepositories, log);
            int numViolations = this.checkForMissingArtifacts(rootDependencyNode, runtimeArtifacts, log);
            if (numViolations > 0) {
                ChoiceFormat dependenciesFormat = new ChoiceFormat("1#dependency|1<dependencies");
                throw new EnforcerRuleException("Found " + numViolations + " missing runtime " + dependenciesFormat.format(numViolations) + ". Look at the warnings emitted above for the details.");
            }
        }
        catch (DependencyCollectionException e) {
            StringWriter writer = new StringWriter();
            TreeDependencyVisitor depVisitor = new TreeDependencyVisitor((DependencyVisitor)new DependencyVisitorPrinter(new PrintWriter(writer)));
            e.getResult().getRoot().accept((DependencyVisitor)depVisitor);
            throw new EnforcerRuleException("Could not retrieve dependency metadata for project  : " + e.getMessage() + ". Partial dependency tree: " + writer.toString(), (Exception)((Object)e));
        }
    }

    private static Exclusion convertPatternToExclusion(String pattern) {
        String[] parts = pattern.split(":");
        if (parts.length > 4) {
            throw new IllegalArgumentException("Pattern must contain at most three colons, but contains " + parts + ": " + pattern);
        }
        String groupId = parts[0];
        String artifactId = "*";
        String extension = "*";
        String classifier = "*";
        if (parts.length > 1) {
            artifactId = parts[1];
        }
        if (parts.length > 2) {
            extension = parts[2];
        }
        if (parts.length > 3) {
            classifier = parts[3];
        }
        return new Exclusion(groupId, artifactId, classifier, extension);
    }

    protected DependencyNode collectTransitiveDependencies(Dependency rootDependency, RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> remoteRepositories, Log log) throws DependencyCollectionException {
        CollectRequest collectRequest = new CollectRequest(rootDependency, remoteRepositories);
        CollectResult collectResult = repoSystem.collectDependencies(repoSession, collectRequest);
        if (log.isDebugEnabled()) {
            StringWriter writer = new StringWriter();
            TreeDependencyVisitor depVisitor = new TreeDependencyVisitor((DependencyVisitor)new DependencyVisitorPrinter(new PrintWriter(writer)));
            collectResult.getRoot().accept((DependencyVisitor)depVisitor);
            log.debug((CharSequence)("dependency tree: " + writer.toString()));
        }
        return collectResult.getRoot();
    }

    protected int checkForMissingArtifacts(DependencyNode rootDependencyNode, List<org.eclipse.aether.artifact.Artifact> runtimeArtifacts, Log log) {
        MissingArtifactsDependencyVisitor depVisitor = new MissingArtifactsDependencyVisitor(runtimeArtifacts, log);
        rootDependencyNode.accept((DependencyVisitor)depVisitor);
        return depVisitor.getNumMissingArtifacts();
    }

    protected static boolean isCompatibleArtifactContainedInList(org.eclipse.aether.artifact.Artifact artifact, List<org.eclipse.aether.artifact.Artifact> artifacts, Log log) throws InvalidVersionSpecificationException {
        for (org.eclipse.aether.artifact.Artifact artifactInList : artifacts) {
            if (!RequireProvidedDependenciesInRuntimeClasspath.areArtifactsEqualDisregardingVersion(artifact, artifactInList)) continue;
            if (RequireProvidedDependenciesInRuntimeClasspath.isVersionCompatible(artifact.getVersion(), artifactInList.getVersion())) {
                return true;
            }
            MessageBuilder msgBuilder = MessageUtils.buffer();
            log.warn((CharSequence)("Found provided dependency " + msgBuilder.strong((Object)artifact).a((CharSequence)" only with potentially incompatible version ").strong((Object)artifactInList.getVersion()).toString() + " in runtime classpath"));
        }
        return false;
    }

    protected static boolean isVersionCompatible(String requiredVersion, String providedVersion) throws InvalidVersionSpecificationException {
        DefaultArtifactVersion provided = new DefaultArtifactVersion(providedVersion);
        VersionRange required = VersionRange.createFromVersionSpec((String)requiredVersion);
        if (required.getRecommendedVersion() == null) {
            return required.containsVersion((ArtifactVersion)provided);
        }
        return required.getRecommendedVersion().getMajorVersion() == provided.getMajorVersion() && required.getRecommendedVersion().getMinorVersion() <= provided.getMinorVersion();
    }

    protected static boolean areArtifactsEqualDisregardingVersion(org.eclipse.aether.artifact.Artifact artifact1, org.eclipse.aether.artifact.Artifact artifact2) {
        return artifact1.getArtifactId().equals(artifact2.getArtifactId()) && artifact1.getGroupId().equals(artifact2.getGroupId()) && Objects.toString(artifact2.getClassifier(), "").equals(Objects.toString(artifact1.getClassifier(), "")) && artifact1.getExtension().equals(artifact2.getExtension());
    }

    public void setExcludes(List<String> theExcludes) {
        this.excludes = theExcludes;
    }

    public void setIncludeOptionalDependencies(boolean includeOptionals) {
        this.includeOptionals = includeOptionals;
    }

    public void setIncludeDirectDependencies(boolean includeDirects) {
        this.includeDirects = includeDirects;
    }

    private static final class MissingArtifactsDependencyVisitor
    implements DependencyVisitor {
        private final List<org.eclipse.aether.artifact.Artifact> artifacts;
        private final Log log;
        private int numMissingArtifacts;
        private final Deque<DependencyNode> nodeStack;
        private boolean isRoot;

        MissingArtifactsDependencyVisitor(List<org.eclipse.aether.artifact.Artifact> artifacts, Log log) {
            this.artifacts = artifacts;
            this.log = log;
            this.numMissingArtifacts = 0;
            this.nodeStack = new ArrayDeque<DependencyNode>();
            this.isRoot = true;
        }

        public boolean visitEnter(DependencyNode dependencyNode) {
            if (this.isRoot) {
                this.isRoot = false;
            } else {
                try {
                    if (!RequireProvidedDependenciesInRuntimeClasspath.isCompatibleArtifactContainedInList(dependencyNode.getArtifact(), this.artifacts, this.log)) {
                        MessageBuilder msgBuilder = MessageUtils.buffer();
                        this.log.warn((CharSequence)msgBuilder.a((CharSequence)"Dependency ").strong((Object)dependencyNode.getDependency()).mojo((Object)MissingArtifactsDependencyVisitor.dumpIntermediatePath(this.nodeStack)).a((CharSequence)" not found as runtime dependency!").toString());
                        ++this.numMissingArtifacts;
                    }
                }
                catch (InvalidVersionSpecificationException e) {
                    this.log.error((CharSequence)("Invalid version given for artifact " + dependencyNode.getArtifact()), (Throwable)e);
                }
                this.nodeStack.addLast(dependencyNode);
            }
            return true;
        }

        public boolean visitLeave(DependencyNode dependencyNode) {
            if (!this.nodeStack.isEmpty()) {
                this.nodeStack.removeLast();
            }
            return true;
        }

        public int getNumMissingArtifacts() {
            return this.numMissingArtifacts;
        }

        private static String dumpIntermediatePath(Collection<DependencyNode> path) {
            if (path.isEmpty()) {
                return "";
            }
            return " via " + path.stream().map(n -> n.getArtifact().toString()).collect(Collectors.joining(" -> "));
        }
    }

    private static final class DependencyVisitorPrinter
    implements DependencyVisitor {
        private final PrintWriter printWriter;
        private String indent = "";

        DependencyVisitorPrinter(PrintWriter printWriter) {
            this.printWriter = printWriter;
        }

        public boolean visitEnter(DependencyNode dependencyNode) {
            String scope = dependencyNode.getDependency() != null ? " (" + dependencyNode.getDependency().getScope() + ")" : "";
            this.printWriter.println(this.indent + dependencyNode.getArtifact() + scope);
            this.indent = this.indent + "    ";
            return true;
        }

        public boolean visitLeave(DependencyNode dependencyNode) {
            this.indent = this.indent.substring(0, this.indent.length() - 4);
            return true;
        }
    }

    private static final class LevelAndScopeExclusionSelector
    implements DependencySelector {
        private final int targetLevel;
        private final String targetScope;
        private final int currentLevel;
        private static final DependencySelector ALL_SELECTOR = new StaticDependencySelector(true);

        public LevelAndScopeExclusionSelector(int targetLevel, String targetScope) {
            this(targetLevel, targetScope, 0);
        }

        private LevelAndScopeExclusionSelector(int targetLevel, String targetScope, int currentLevel) {
            this.targetLevel = targetLevel;
            this.targetScope = Objects.requireNonNull(targetScope);
            this.currentLevel = currentLevel;
        }

        public boolean selectDependency(Dependency dependency) {
            if (this.currentLevel == this.targetLevel) {
                return !this.targetScope.equals(dependency.getScope());
            }
            return true;
        }

        public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
            if (this.currentLevel < this.targetLevel) {
                return new LevelAndScopeExclusionSelector(this.targetLevel, this.targetScope, this.currentLevel + 1);
            }
            return ALL_SELECTOR;
        }
    }
}

