/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.sling.maven.bundlesupport.AbstractBundleInstallMojo;
import org.codehaus.plexus.util.StringUtils;

public class BundleInstallFileMojo
extends AbstractBundleInstallMojo {
    private String bundleFileName;
    private String groupId;
    private String artifactId;
    private String version;
    private String packaging = "jar";
    private String artifact;
    private List pomRemoteRepositories;
    private String repositoryId = "temp";
    private String repositoryUrl;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private ArtifactRepositoryLayout repositoryLayout;
    private ArtifactRepository localRepository;

    protected String getBundleFileName() throws MojoExecutionException {
        String fileName = this.bundleFileName;
        if (fileName == null && (fileName = this.resolveBundleFileFromArtifact()) == null) {
            throw new MojoExecutionException("Must provide either sling.file or sling.artifact parameters");
        }
        return fileName;
    }

    private String resolveBundleFileFromArtifact() throws MojoExecutionException {
        if (this.artifactId == null && this.artifact == null) {
            return null;
        }
        if (this.artifactId == null) {
            String[] tokens = StringUtils.split((String)this.artifact, (String)":");
            if (tokens.length != 3 && tokens.length != 4) {
                throw new MojoExecutionException("Invalid artifact, you must specify groupId:artifactId:version[:packaging] " + this.artifact);
            }
            this.groupId = tokens[0];
            this.artifactId = tokens[1];
            this.version = tokens[2];
            if (tokens.length == 4) {
                this.packaging = tokens[3];
            }
        }
        Artifact packageArtifact = this.artifactFactory.createBuildArtifact(this.groupId, this.artifactId, this.version, this.packaging);
        if (this.pomRemoteRepositories == null) {
            this.pomRemoteRepositories = new ArrayList();
        }
        ArrayList<ArtifactRepository> repoList = new ArrayList<ArtifactRepository>(this.pomRemoteRepositories);
        if (this.repositoryUrl != null) {
            ArtifactRepositoryPolicy policy = new ArtifactRepositoryPolicy(true, "always", "warn");
            ArtifactRepository remoteRepo = this.artifactRepositoryFactory.createArtifactRepository(this.repositoryId, this.repositoryUrl, this.repositoryLayout, policy, policy);
            repoList.add(remoteRepo);
        }
        try {
            this.artifactResolver.resolve(packageArtifact, repoList, this.localRepository);
            this.getLog().info((CharSequence)("Resolved artifact to " + packageArtifact.getFile().getAbsolutePath()));
        }
        catch (AbstractArtifactResolutionException e) {
            throw new MojoExecutionException("Couldn't download artifact: " + e.getMessage(), (Exception)((Object)e));
        }
        return packageArtifact.getFile().getAbsolutePath();
    }
}

