/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.FilePartSource;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.bundlesupport.AbstractBundlePostMojo;
import org.apache.sling.maven.bundlesupport.IntermediateUrisExtractor;
import org.apache.sling.maven.bundlesupport.MkColMethod;
import org.apache.sling.maven.bundlesupport.fsresource.SlingInitialContentMounter;

abstract class AbstractBundleInstallMojo
extends AbstractBundlePostMojo {
    @Parameter(property="sling.usePut", defaultValue="false")
    protected boolean usePut;
    @Parameter(property="sling.deploy.method", required=false)
    protected BundleDeploymentMethod deploymentMethod;
    @Parameter(property="sling.mimeType", defaultValue="application/java-archive", required=true)
    protected String mimeType;
    @Parameter(property="sling.bundle.startlevel", defaultValue="20", required=true)
    private String bundleStartLevel;
    @Parameter(property="sling.bundle.start", defaultValue="true", required=true)
    private boolean bundleStart;
    @Parameter(property="sling.refreshPackages", defaultValue="true", required=true)
    private boolean refreshPackages;
    @Parameter(property="sling.mountByFS", defaultValue="false", required=true)
    private boolean mountByFS;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;

    protected abstract String getBundleFileName() throws MojoExecutionException;

    protected String getURLWithFilename(String targetURL, String fileName) {
        return targetURL + (targetURL.endsWith("/") ? "" : "/") + fileName;
    }

    public void execute() throws MojoExecutionException {
        String bundleFileName = this.getBundleFileName();
        File bundleFile = new File(bundleFileName);
        if (!bundleFile.exists()) {
            this.getLog().info((CharSequence)(bundleFile + " does not exist, no uploading"));
            return;
        }
        String bundleName = this.getBundleSymbolicName(bundleFile);
        if (bundleName == null) {
            this.getLog().info((CharSequence)(bundleFile + " is not an OSGi Bundle, not uploading"));
            return;
        }
        String targetURL = this.getTargetURL();
        BundleDeploymentMethod deploymentMethod = this.getDeploymentMethod();
        this.getLog().info((CharSequence)("Installing Bundle " + bundleName + "(" + bundleFile + ") to " + targetURL + " via " + (Object)((Object)deploymentMethod)));
        switch (deploymentMethod) {
            case SlingPostServlet: {
                this.postToSling(targetURL, bundleFile);
                break;
            }
            case WebConsole: {
                this.postToFelix(targetURL, bundleFile);
                break;
            }
            case WebDAV: {
                this.putViaWebDav(targetURL, bundleFile);
                break;
            }
            default: {
                throw new MojoExecutionException("Unrecognized BundleDeployMethod " + (Object)((Object)deploymentMethod));
            }
        }
        if (this.mountByFS) {
            this.configure(this.getConsoleTargetURL(), bundleFile);
        }
    }

    protected void configure(String targetURL, File file) throws MojoExecutionException {
        new SlingInitialContentMounter(this.getLog(), this.getHttpClient(), this.project).mount(targetURL, file);
    }

    protected BundleDeploymentMethod getDeploymentMethod() throws MojoExecutionException {
        if (this.deploymentMethod == null) {
            if (this.usePut) {
                this.getLog().warn((CharSequence)"Using deprecated configuration parameter 'usePut=true', please instead use the new parameter 'deploymentMethod=WebDAV'!");
                return BundleDeploymentMethod.WebDAV;
            }
            return BundleDeploymentMethod.WebConsole;
        }
        return this.deploymentMethod;
    }

    protected void postToFelix(String targetURL, File file) throws MojoExecutionException {
        PostMethod filePost = new PostMethod(targetURL + "/install");
        try {
            filePost.setRequestHeader("referer", "about:blank");
            ArrayList<Object> partList = new ArrayList<Object>();
            partList.add(new StringPart("action", "install"));
            partList.add(new StringPart("_noredir_", "_noredir_"));
            partList.add(new FilePart("bundlefile", (PartSource)new FilePartSource(file.getName(), file)));
            partList.add(new StringPart("bundlestartlevel", this.bundleStartLevel));
            if (this.bundleStart) {
                partList.add(new StringPart("bundlestart", "start"));
            }
            if (this.refreshPackages) {
                partList.add(new StringPart("refreshPackages", "true"));
            }
            Part[] parts = partList.toArray(new Part[partList.size()]);
            filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
            int status = this.getHttpClient().executeMethod((HttpMethod)filePost);
            if (status == 200) {
                this.getLog().info((CharSequence)"Bundle installed");
            } else {
                String msg = "Installation failed, cause: " + HttpStatus.getStatusText((int)status);
                if (this.failOnError) {
                    throw new MojoExecutionException(msg);
                }
                this.getLog().error((CharSequence)msg);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Installation on " + targetURL + " failed, cause: " + ex.getMessage(), ex);
        }
        finally {
            filePost.releaseConnection();
        }
    }

    protected void postToSling(String targetURL, File file) throws MojoExecutionException {
        if (targetURL.endsWith("/")) {
            targetURL = targetURL.substring(0, targetURL.length() - 1);
        }
        PostMethod filePost = new PostMethod(targetURL);
        try {
            Part[] parts = new Part[]{new FilePart("*", (PartSource)new FilePartSource(file.getName(), file), this.mimeType, null), new StringPart("*@TypeHint", "nt:file")};
            filePost.setRequestHeader("Accept", "application/json");
            filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
            int status = this.getHttpClient().executeMethod((HttpMethod)filePost);
            if (status == 200 || status == 201) {
                this.getLog().info((CharSequence)"Bundle installed");
            } else {
                String msg = "Installation failed, cause: " + HttpStatus.getStatusText((int)status);
                if (this.failOnError) {
                    throw new MojoExecutionException(msg);
                }
                this.getLog().error((CharSequence)msg);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Installation on " + targetURL + " failed, cause: " + ex.getMessage(), ex);
        }
        finally {
            filePost.releaseConnection();
        }
    }

    protected void putViaWebDav(String targetURL, File file) throws MojoExecutionException {
        boolean success = false;
        try {
            int status = this.performPut(targetURL, file);
            if (status >= 200 && status < 300) {
                success = true;
            } else if (status == 409) {
                this.getLog().debug((CharSequence)"Bundle not installed due missing parent folders. Attempting to create parent structure.");
                this.createIntermediaryPaths(targetURL);
                this.getLog().debug((CharSequence)"Re-attempting bundle install after creating parent folders.");
                status = this.performPut(targetURL, file);
                if (status >= 200 && status < 300) {
                    success = true;
                }
            }
            if (!success) {
                String msg = "Installation failed, cause: " + HttpStatus.getStatusText((int)status);
                if (this.failOnError) {
                    throw new MojoExecutionException(msg);
                }
                this.getLog().error((CharSequence)msg);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Installation on " + targetURL + " failed, cause: " + ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int performPut(String targetURL, File file) throws HttpException, IOException {
        PutMethod filePut = new PutMethod(this.getURLWithFilename(targetURL, file.getName()));
        try {
            filePut.setRequestEntity((RequestEntity)new FileRequestEntity(file, this.mimeType));
            int n = this.getHttpClient().executeMethod((HttpMethod)filePut);
            return n;
        }
        finally {
            filePut.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int performHead(String uri) throws HttpException, IOException {
        HeadMethod head = new HeadMethod(uri);
        try {
            int n = this.getHttpClient().executeMethod((HttpMethod)head);
            return n;
        }
        finally {
            head.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int performMkCol(String uri) throws IOException {
        MkColMethod mkCol = new MkColMethod(uri);
        try {
            int n = this.getHttpClient().executeMethod((HttpMethod)mkCol);
            return n;
        }
        finally {
            mkCol.releaseConnection();
        }
    }

    private void createIntermediaryPaths(String targetURL) throws HttpException, IOException, MojoExecutionException {
        List<String> intermediateUris = IntermediateUrisExtractor.extractIntermediateUris(targetURL);
        String existingIntermediateUri = null;
        for (String intermediateUri : intermediateUris) {
            int result = this.performHead(intermediateUri);
            if (result == 200) {
                existingIntermediateUri = intermediateUri;
                break;
            }
            if (result == 404) continue;
            throw new MojoExecutionException("Failed getting intermediate path at " + intermediateUri + ". Reason: " + HttpStatus.getStatusText((int)result));
        }
        if (existingIntermediateUri == null) {
            throw new MojoExecutionException("Could not find any intermediate path up until the root of " + targetURL + ".");
        }
        int startOfInexistingIntermediateUri = intermediateUris.indexOf(existingIntermediateUri);
        if (startOfInexistingIntermediateUri == -1) {
            throw new IllegalStateException("Could not find intermediate uri " + existingIntermediateUri + " in the list");
        }
        for (int index = startOfInexistingIntermediateUri - 1; index >= 0; --index) {
            String intermediateUri = intermediateUris.get(index);
            int result = this.performMkCol(intermediateUri);
            if (result != 201 && result != 200) {
                throw new MojoExecutionException("Failed creating intermediate path at '" + intermediateUri + "'. Reason: " + HttpStatus.getStatusText((int)result));
            }
            this.getLog().debug((CharSequence)("Intermediate path at " + intermediateUri + " successfully created"));
        }
    }

    static enum BundleDeploymentMethod {
        WebConsole,
        WebDAV,
        SlingPostServlet;

    }
}

