/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.json.JsonException;
import org.apache.commons.io.IOUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.bundlesupport.JsonSupport;
import org.codehaus.plexus.util.DirectoryScanner;

@Mojo(name="validate", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class ValidationMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="sling.validation.skip", defaultValue="false", required=true)
    private boolean skip;
    @Parameter(property="sling.validation.skipJson", defaultValue="false", required=true)
    private boolean skipJson;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Validation is skipped.");
            return;
        }
        for (Resource rsrc : this.project.getResources()) {
            File directory = new File(rsrc.getDirectory());
            if (!directory.exists()) continue;
            this.getLog().debug((CharSequence)("Scanning " + rsrc.getDirectory()));
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(directory);
            if (rsrc.getExcludes() != null && rsrc.getExcludes().size() > 0) {
                scanner.setExcludes(rsrc.getExcludes().toArray(new String[rsrc.getExcludes().size()]));
            }
            scanner.addDefaultExcludes();
            if (rsrc.getIncludes() != null && rsrc.getIncludes().size() > 0) {
                scanner.setIncludes(rsrc.getIncludes().toArray(new String[rsrc.getIncludes().size()]));
            }
            scanner.scan();
            String[] files = scanner.getIncludedFiles();
            if (files == null) continue;
            for (int m = 0; m < files.length; ++m) {
                this.validate(directory, files[m]);
            }
        }
    }

    private void validate(File directory, String fileName) throws MojoExecutionException {
        block6: {
            this.getLog().debug((CharSequence)("Validating " + fileName));
            File file = new File(directory, fileName);
            if (!file.isFile() || !fileName.endsWith(".json") || this.skipJson) break block6;
            this.getLog().debug((CharSequence)("Validation JSON file " + fileName));
            FileInputStream fis = null;
            String json = null;
            try {
                fis = new FileInputStream(file);
                json = IOUtils.toString((InputStream)fis, (String)"UTF-8");
            }
            catch (IOException e) {
                try {
                    throw new MojoExecutionException("An Error occured while validating the file '" + fileName + "'", (Exception)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)fis);
            try {
                JsonSupport.validateJsonStructure(json);
            }
            catch (JsonException e) {
                throw new MojoExecutionException("An Error occured while validating the file '" + fileName + "'", (Exception)((Object)e));
            }
        }
    }
}

