/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.adapter.internal;

import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdapterFactoryDescriptorKey
implements Comparable<AdapterFactoryDescriptorKey> {
    private long bundleId;
    private long serviceId;

    public AdapterFactoryDescriptorKey(ServiceReference ref) {
        this.bundleId = ref.getBundle().getBundleId();
        this.serviceId = OsgiUtil.toLong((Object)ref.getProperty("service.id"), (long)-1L);
    }

    @Override
    public int compareTo(AdapterFactoryDescriptorKey o) {
        if (o.equals(this)) {
            return 0;
        }
        if (this.bundleId < o.bundleId) {
            return -1;
        }
        if (this.bundleId > o.bundleId) {
            return 1;
        }
        if (this.serviceId < o.serviceId) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AdapterFactoryDescriptorKey) {
            AdapterFactoryDescriptorKey oKey = (AdapterFactoryDescriptorKey)o;
            return this.bundleId == oKey.bundleId && this.serviceId == oKey.serviceId;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.bundleId * 33L + this.serviceId);
    }
}

