/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.adapter.internal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.adapter.internal.AdapterFactoryDescriptor;
import org.apache.sling.adapter.internal.AdapterFactoryDescriptorMap;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(immediate=true)
@Service
@Properties(value={@Property(name="service.description", value={"Sling Adapter Manager"}), @Property(name="service.vendor", value={"The Apache Software Foundation"})})
@Reference(name="AdapterFactory", referenceInterface=AdapterFactory.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
public class AdapterManagerImpl
implements AdapterManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile ComponentContext context;
    private final List<ServiceReference> boundAdapterFactories = new LinkedList<ServiceReference>();
    private final Map<String, AdapterFactoryDescriptorMap> descriptors = new HashMap<String, AdapterFactoryDescriptorMap>();
    private final ConcurrentMap<String, Map<String, List<AdapterFactoryDescriptor>>> factoryCache = new ConcurrentHashMap<String, Map<String, List<AdapterFactoryDescriptor>>>();
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private volatile EventAdmin eventAdmin;

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        Map<String, List<AdapterFactoryDescriptor>> factories = this.getAdapterFactories(adaptable.getClass());
        List<AdapterFactoryDescriptor> descList = factories.get(type.getName());
        if (descList != null && descList.size() > 0) {
            for (AdapterFactoryDescriptor desc : descList) {
                AdapterFactory factory = desc == null ? null : desc.getFactory();
                if (factory == null) continue;
                this.log.debug("Trying adapter factory {} to map {} to {}", new Object[]{factory, adaptable, type});
                Object adaptedObject = factory.getAdapter(adaptable, type);
                if (adaptedObject == null) continue;
                this.log.debug("Using adapter factory {} to map {} to {}", new Object[]{factory, adaptable, type});
                return (AdapterType)adaptedObject;
            }
        }
        this.log.debug("No adapter factory found to map {} to {}", adaptable, type);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context) {
        ArrayList<ServiceReference> refs;
        this.context = context;
        List<ServiceReference> list = this.boundAdapterFactories;
        synchronized (list) {
            refs = new ArrayList<ServiceReference>(this.boundAdapterFactories);
            this.boundAdapterFactories.clear();
        }
        for (ServiceReference reference : refs) {
            this.registerAdapterFactory(context, reference);
        }
        SyntheticResource.setAdapterManager((AdapterManager)this);
    }

    protected void deactivate(ComponentContext context) {
        SyntheticResource.unsetAdapterManager((AdapterManager)this);
        this.context = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindAdapterFactory(ServiceReference reference) {
        boolean create = true;
        if (this.context == null) {
            List<ServiceReference> list = this.boundAdapterFactories;
            synchronized (list) {
                if (this.context == null) {
                    this.boundAdapterFactories.add(reference);
                    create = false;
                }
            }
        }
        if (create) {
            this.registerAdapterFactory(this.context, reference);
        }
    }

    protected void unbindAdapterFactory(ServiceReference reference) {
        this.unregisterAdapterFactory(reference);
    }

    Map<String, AdapterFactoryDescriptorMap> getFactories() {
        return this.descriptors;
    }

    Map<String, Map<String, List<AdapterFactoryDescriptor>>> getFactoryCache() {
        return this.factoryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAdapterFactory(ComponentContext context, ServiceReference reference) {
        String[] adaptables = PropertiesUtil.toStringArray((Object)reference.getProperty("adaptables"));
        String[] adapters = PropertiesUtil.toStringArray((Object)reference.getProperty("adapters"));
        if (adaptables == null || adaptables.length == 0 || adapters == null || adapters.length == 0) {
            return;
        }
        AdapterFactoryDescriptor factoryDesc = new AdapterFactoryDescriptor(context, reference, adapters);
        for (String adaptable : adaptables) {
            AdapterFactoryDescriptorMap adfMap = null;
            AdapterFactoryDescriptorMap adapterFactoryDescriptorMap = this.descriptors;
            synchronized (adapterFactoryDescriptorMap) {
                adfMap = this.descriptors.get(adaptable);
                if (adfMap == null) {
                    adfMap = new AdapterFactoryDescriptorMap();
                    this.descriptors.put(adaptable, adfMap);
                }
            }
            adapterFactoryDescriptorMap = adfMap;
            synchronized (adapterFactoryDescriptorMap) {
                adfMap.put(reference, factoryDesc);
            }
        }
        this.factoryCache.clear();
        EventAdmin localEA = this.eventAdmin;
        if (localEA != null) {
            Hashtable<String, String[]> props = new Hashtable<String, String[]>();
            ((Dictionary)props).put("adaptables", adaptables);
            ((Dictionary)props).put("adapters", adapters);
            localEA.postEvent(new Event("org/apache/sling/api/adapter/AdapterFactory/ADDED", props));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAdapterFactory(ServiceReference reference) {
        EventAdmin localEA;
        List<ServiceReference> list = this.boundAdapterFactories;
        synchronized (list) {
            this.boundAdapterFactories.remove(reference);
        }
        String[] adaptables = PropertiesUtil.toStringArray((Object)reference.getProperty("adaptables"));
        String[] adapters = PropertiesUtil.toStringArray((Object)reference.getProperty("adapters"));
        if (adaptables == null || adaptables.length == 0 || adapters == null || adapters.length == 0) {
            return;
        }
        boolean factoriesModified = false;
        AdapterFactoryDescriptorMap adfMap = null;
        for (String adaptable : adaptables) {
            AdapterFactoryDescriptorMap adapterFactoryDescriptorMap = this.descriptors;
            synchronized (adapterFactoryDescriptorMap) {
                adfMap = this.descriptors.get(adaptable);
            }
            if (adfMap == null) continue;
            adapterFactoryDescriptorMap = adfMap;
            synchronized (adapterFactoryDescriptorMap) {
                factoriesModified |= adfMap.remove(reference) != null;
            }
        }
        if (factoriesModified) {
            this.factoryCache.clear();
        }
        if ((localEA = this.eventAdmin) != null) {
            Hashtable<String, String[]> props = new Hashtable<String, String[]>();
            ((Dictionary)props).put("adaptables", adaptables);
            ((Dictionary)props).put("adapters", adapters);
            localEA.postEvent(new Event("org/apache/sling/api/adapter/AdapterFactory/REMOVED", props));
        }
    }

    private Map<String, List<AdapterFactoryDescriptor>> getAdapterFactories(Class<?> clazz) {
        String className = clazz.getName();
        Map<String, List<AdapterFactoryDescriptor>> entry = (Map<String, List<AdapterFactoryDescriptor>>)this.factoryCache.get(className);
        if (entry == null) {
            entry = this.createAdapterFactoryMap(clazz);
            this.factoryCache.put(className, entry);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<AdapterFactoryDescriptor>> createAdapterFactoryMap(Class<?> clazz) {
        Class<?>[] interfaces;
        HashMap<String, List<AdapterFactoryDescriptor>> afm = new HashMap<String, List<AdapterFactoryDescriptor>>();
        AdapterFactoryDescriptorMap afdMap = null;
        Map<String, AdapterFactoryDescriptorMap> map = this.descriptors;
        synchronized (map) {
            afdMap = this.descriptors.get(clazz.getName());
        }
        if (afdMap != null) {
            ArrayList afdSet;
            AdapterFactoryDescriptorMap adapterFactoryDescriptorMap = afdMap;
            synchronized (adapterFactoryDescriptorMap) {
                afdSet = new ArrayList(afdMap.values());
            }
            for (AdapterFactoryDescriptor afd : afdSet) {
                String[] adapters;
                for (String adapter : adapters = afd.getAdapters()) {
                    ArrayList<AdapterFactoryDescriptor> factoryDescriptors = (ArrayList<AdapterFactoryDescriptor>)afm.get(adapter);
                    if (factoryDescriptors == null) {
                        factoryDescriptors = new ArrayList<AdapterFactoryDescriptor>();
                        afm.put(adapter, factoryDescriptors);
                    }
                    factoryDescriptors.add(afd);
                }
            }
        }
        for (Class<?> iFace : interfaces = clazz.getInterfaces()) {
            this.copyAdapterFactories(afm, iFace);
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            this.copyAdapterFactories(afm, superClazz);
        }
        return afm;
    }

    private void copyAdapterFactories(Map<String, List<AdapterFactoryDescriptor>> dest, Class<?> clazz) {
        Map<String, List<AdapterFactoryDescriptor>> scMap = this.getAdapterFactories(clazz);
        for (Map.Entry<String, List<AdapterFactoryDescriptor>> entry : scMap.entrySet()) {
            List<AdapterFactoryDescriptor> factoryDescriptors = dest.get(entry.getKey());
            if (factoryDescriptors == null) {
                factoryDescriptors = new ArrayList<AdapterFactoryDescriptor>();
                dest.put(entry.getKey(), factoryDescriptors);
            }
            for (AdapterFactoryDescriptor descriptor : entry.getValue()) {
                factoryDescriptors.add(descriptor);
            }
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }
}

