/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.adapter.internal;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.adapter.internal.AdapterManagerImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.converter.Converter;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.description=Adapter Web Console Plugin", "service.vendor=The Apache Software Foundation", "felix.webconsole.label=adapters", "felix.webconsole.title=Sling Adapters", "felix.webconsole.css=/adapters/res/ui/adapters.css", "felix.webconsole.configprinter.modes=always", "felix.webconsole.category=Sling"})
public class AdapterWebConsolePlugin
extends HttpServlet
implements ServiceTrackerCustomizer,
BundleListener {
    private static final String ADAPTER_CONDITION = "adapter.condition";
    private static final String ADAPTER_DEPRECATED = "adapter.deprecated";
    private final Logger logger = LoggerFactory.getLogger(AdapterWebConsolePlugin.class);
    @Reference
    private PackageAdmin packageAdmin;
    private List<AdaptableDescription> allAdaptables;
    private Map<ServiceReference, List<AdaptableDescription>> adapterServiceReferences;
    private Map<Bundle, List<AdaptableDescription>> adapterBundles;
    private ServiceTracker adapterTracker;
    private BundleContext bundleContext;

    public Object addingService(ServiceReference reference) {
        this.addServiceMetadata(reference);
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServiceMetadata(ServiceReference reference) {
        Converter converter = Converters.standardConverter();
        String[] adaptables = (String[])converter.convert(reference.getProperty("adaptables")).to(String[].class);
        String[] adapters = (String[])converter.convert(reference.getProperty("adapters")).to(String[].class);
        String condition = (String)((Converting)converter.convert(reference.getProperty(ADAPTER_CONDITION)).defaultValue((Object)"")).to(String.class);
        boolean deprecated = (Boolean)((Converting)converter.convert(reference.getProperty(ADAPTER_DEPRECATED)).defaultValue((Object)false)).to(Boolean.class);
        if (adapters != null && adapters.length > 0) {
            ArrayList<AdaptableDescription> descriptions = new ArrayList<AdaptableDescription>(adaptables.length);
            for (String adaptable : adaptables) {
                descriptions.add(new AdaptableDescription(reference.getBundle(), adaptable, adapters, condition, deprecated));
            }
            AdapterWebConsolePlugin adapterWebConsolePlugin = this;
            synchronized (adapterWebConsolePlugin) {
                this.adapterServiceReferences.put(reference, descriptions);
                this.update();
            }
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 4) {
            this.removeBundle(event.getBundle());
        } else if (event.getType() == 2) {
            this.addBundle(event.getBundle());
        }
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.addServiceMetadata(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference reference, Object service) {
        AdapterWebConsolePlugin adapterWebConsolePlugin = this;
        synchronized (adapterWebConsolePlugin) {
            this.adapterServiceReferences.remove(reference);
            this.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBundle(Bundle bundle) {
        block16: {
            ArrayList<AdaptableDescription> descs = new ArrayList<AdaptableDescription>();
            try {
                Enumeration files = bundle.getResources("SLING-INF/adapters.json");
                if (files != null) {
                    while (files.hasMoreElements()) {
                        try (InputStreamReader reader = new InputStreamReader(((URL)files.nextElement()).openStream(), StandardCharsets.UTF_8);){
                            HashMap<String, Boolean> config = new HashMap<String, Boolean>();
                            config.put("org.apache.johnzon.supports-comments", true);
                            JsonObject obj = Json.createReaderFactory(config).createReader((Reader)reader).readObject();
                            for (String adaptableName : obj.keySet()) {
                                JsonObject adaptable = obj.getJsonObject(adaptableName);
                                for (String condition : adaptable.keySet()) {
                                    Object value = adaptable.get((Object)condition);
                                    String[] adapters = value instanceof JsonArray ? this.toStringArray((JsonArray)value) : new String[]{this.unbox(value).toString()};
                                    descs.add(new AdaptableDescription(bundle, adaptableName, adapters, condition, false));
                                }
                            }
                        }
                    }
                }
                if (descs.isEmpty()) break block16;
                AdapterWebConsolePlugin adapterWebConsolePlugin = this;
                synchronized (adapterWebConsolePlugin) {
                    this.adapterBundles.put(bundle, descs);
                    this.update();
                }
            }
            catch (IOException e) {
                this.logger.error("Unable to load adapter descriptors for bundle " + bundle, (Throwable)e);
            }
            catch (JsonException e) {
                this.logger.error("Unable to load adapter descriptors for bundle " + bundle, (Throwable)e);
            }
            catch (IllegalStateException e) {
                this.logger.debug("Unable to load adapter descriptors for bundle " + bundle);
            }
        }
    }

    private Object unbox(Object o) {
        if (o instanceof JsonValue) {
            switch (((JsonValue)o).getValueType()) {
                case FALSE: {
                    return false;
                }
                case TRUE: {
                    return true;
                }
                case NULL: {
                    return null;
                }
                case NUMBER: {
                    return ((JsonNumber)o).isIntegral() ? (double)((JsonNumber)o).longValue() : ((JsonNumber)o).doubleValue();
                }
                case STRING: {
                    return ((JsonString)o).getString();
                }
            }
            return o;
        }
        return o;
    }

    private String[] toStringArray(JsonArray value) {
        ArrayList<String> result = new ArrayList<String>(value.size());
        for (int i = 0; i < value.size(); ++i) {
            result.add(value.getString(i));
        }
        return result.toArray(new String[value.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBundle(Bundle bundle) {
        AdapterWebConsolePlugin adapterWebConsolePlugin = this;
        synchronized (adapterWebConsolePlugin) {
            this.adapterBundles.remove(bundle);
            this.update();
        }
    }

    private void update() {
        ArrayList<AdaptableDescription> newList = new ArrayList<AdaptableDescription>();
        for (List<AdaptableDescription> descriptions : this.adapterServiceReferences.values()) {
            newList.addAll(descriptions);
        }
        for (List<AdaptableDescription> list : this.adapterBundles.values()) {
            newList.addAll(list);
        }
        Collections.sort(newList);
        this.allAdaptables = newList;
    }

    @Activate
    protected void activate(BundleContext ctx) throws InvalidSyntaxException {
        this.bundleContext = ctx;
        this.adapterServiceReferences = new HashMap<ServiceReference, List<AdaptableDescription>>();
        this.adapterBundles = new HashMap<Bundle, List<AdaptableDescription>>();
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (bundle.getState() != 32) continue;
            this.addBundle(bundle);
        }
        this.bundleContext.addBundleListener((BundleListener)this);
        Filter filter = this.bundleContext.createFilter("(&(adaptables=*)(adapters=*)(objectClass=org.apache.sling.api.adapter.AdapterFactory))");
        this.adapterTracker = new ServiceTracker(this.bundleContext, filter, (ServiceTrackerCustomizer)this);
        this.adapterTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this.bundleContext.removeBundleListener((BundleListener)this);
        this.adapterTracker.close();
        this.adapterServiceReferences = null;
        this.adapterBundles = null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getPathInfo().endsWith("/data.json")) {
            this.getJson(resp);
        } else {
            this.getHtml(resp);
        }
    }

    private void getJson(HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/json");
        try {
            HashMap<String, Map<String, ArrayList<String>>> values = new HashMap<String, Map<String, ArrayList<String>>>();
            for (AdaptableDescription desc : this.allAdaptables) {
                Map<String, ArrayList<String>> adaptableObj;
                if (values.containsKey(desc.adaptable)) {
                    adaptableObj = (Map)values.get(desc.adaptable);
                } else {
                    adaptableObj = new HashMap();
                    values.put(desc.adaptable, adaptableObj);
                }
                for (String adapter : desc.adapters) {
                    ArrayList<String> conditions = (ArrayList<String>)adaptableObj.get(desc.condition == null ? "" : desc.condition);
                    if (conditions == null) {
                        conditions = new ArrayList<String>();
                        adaptableObj.put(desc.condition == null ? "" : desc.condition, conditions);
                    }
                    conditions.add(adapter);
                }
            }
            JsonObjectBuilder obj = Json.createObjectBuilder();
            for (Map.Entry entry : values.entrySet()) {
                JsonObjectBuilder adaptable = Json.createObjectBuilder();
                for (Map.Entry subEnty : ((Map)entry.getValue()).entrySet()) {
                    if (((List)subEnty.getValue()).size() > 1) {
                        JsonArrayBuilder array = Json.createArrayBuilder();
                        for (String condition : (List)subEnty.getValue()) {
                            array.add(condition);
                        }
                        adaptable.add((String)subEnty.getKey(), array);
                        continue;
                    }
                    adaptable.add((String)subEnty.getKey(), (String)((List)subEnty.getValue()).get(0));
                }
                obj.add((String)entry.getKey(), adaptable);
            }
            Json.createGenerator((Writer)resp.getWriter()).write((JsonValue)obj.build()).flush();
        }
        catch (JsonException e) {
            throw new ServletException("Unable to produce JSON", (Throwable)e);
        }
    }

    private void getHtml(HttpServletResponse resp) throws IOException {
        PrintWriter writer = resp.getWriter();
        writer.println("<p class=\"statline ui-state-highlight\">${Introduction}</p>");
        writer.println("<p>${intro}</p>");
        writer.println("<p class=\"statline ui-state-highlight\">${How to Use This Information}</p>");
        writer.println("<p>${usage}</p>");
        writer.println("<table class=\"adapters nicetable\">");
        writer.println("<thead><tr><th class=\"header\">${Adaptable Class}</th><th class=\"header\">${Adapter Class}</th><th class=\"header\">${Condition}</th><th class=\"header\">${Deprecated}</th><th class=\"header\">${Providing Bundle}</th></tr></thead>");
        String rowClass = "odd";
        for (AdaptableDescription desc : this.allAdaptables) {
            writer.printf("<tr class=\"%s ui-state-default\"><td>", rowClass);
            boolean packageExported = AdapterManagerImpl.checkPackage(this.packageAdmin, desc.adaptable);
            if (!packageExported) {
                writer.print("<span class='error'>");
            }
            writer.print(desc.adaptable);
            if (!packageExported) {
                writer.print("</span>");
            }
            writer.print("</td>");
            writer.print("<td>");
            for (String adapter : desc.adapters) {
                packageExported = AdapterManagerImpl.checkPackage(this.packageAdmin, adapter);
                if (!packageExported) {
                    writer.print("<span class='error'>");
                }
                writer.print(adapter);
                if (!packageExported) {
                    writer.print("</span>");
                }
                writer.print("<br/>");
            }
            writer.print("</td>");
            if (desc.condition == null) {
                writer.print("<td>&nbsp;</td>");
            } else {
                writer.printf("<td>%s</td>", desc.condition);
            }
            if (desc.deprecated) {
                writer.print("<td>${Deprecated}</td>");
            } else {
                writer.print("<td></td>");
            }
            writer.printf("<td><a href=\"${pluginRoot}/../bundles/%s\">%s (%s)</a></td>", desc.bundle.getBundleId(), desc.bundle.getSymbolicName(), desc.bundle.getBundleId());
            writer.println("</tr>");
            if (rowClass.equals("odd")) {
                rowClass = "even";
                continue;
            }
            rowClass = "odd";
        }
        writer.println("</table>");
    }

    public void printConfiguration(PrintWriter pw) {
        pw.println("Current Apache Sling Adaptables:");
        for (AdaptableDescription desc : this.allAdaptables) {
            pw.printf("Adaptable: %s\n", desc.adaptable);
            if (desc.condition != null) {
                pw.printf("Condition: %s\n", desc.condition);
            }
            pw.printf("Providing Bundle: %s\n", desc.bundle.getSymbolicName());
            pw.printf("Available Adapters:\n", new Object[0]);
            for (String adapter : desc.adapters) {
                pw.print(" * ");
                pw.println(adapter);
            }
            pw.println();
        }
    }

    private URL getResource(String path) {
        if (path.startsWith("/adapters/res/ui/")) {
            return ((Object)((Object)this)).getClass().getResource(path.substring(9));
        }
        return null;
    }

    class AdaptableDescription
    implements Comparable<AdaptableDescription> {
        private final String adaptable;
        private final String[] adapters;
        private final String condition;
        private final Bundle bundle;
        private final boolean deprecated;

        public AdaptableDescription(Bundle bundle, String adaptable, String[] adapters, String condition, boolean deprecated) {
            this.adaptable = adaptable;
            this.adapters = adapters;
            this.condition = condition;
            this.bundle = bundle;
            this.deprecated = deprecated;
        }

        public String toString() {
            return "AdapterDescription [adaptable=" + this.adaptable + ", adapters=" + Arrays.toString(this.adapters) + ", condition=" + this.condition + ", bundle=" + this.bundle + ", deprecated= " + this.deprecated + "]";
        }

        @Override
        public int compareTo(AdaptableDescription o) {
            int result = this.adaptable.compareTo(o.adaptable);
            if (result == 0 && (result = this.condition.compareTo(o.condition)) == 0 && (result = this.adapters.length - o.adapters.length) == 0) {
                result = (int)this.bundle.getBundleId() - (int)o.bundle.getBundleId();
            }
            return result;
        }
    }
}

