/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.resource;

import java.util.Iterator;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResource
implements Resource {
    private static volatile AdapterManager ADAPTER_MANAGER;

    public static void setAdapterManager(AdapterManager adapterMgr) {
        ADAPTER_MANAGER = adapterMgr;
    }

    public static void unsetAdapterManager(AdapterManager adapterMgr) {
        if (ADAPTER_MANAGER == adapterMgr) {
            ADAPTER_MANAGER = null;
        }
    }

    @Override
    public String getName() {
        return ResourceUtil.getName(this.getPath());
    }

    @Override
    public Resource getParent() {
        return ResourceUtil.getParent(this);
    }

    @Override
    public Resource getChild(String relPath) {
        return this.getResourceResolver().getResource(this, relPath);
    }

    @Override
    public Iterator<Resource> listChildren() {
        return this.getResourceResolver().listChildren(this);
    }

    @Override
    public boolean isResourceType(String resourceType) {
        return ResourceUtil.isA(this, resourceType);
    }

    public <Type> Type adaptTo(Class<Type> type) {
        AdapterManager adapterMgr = ADAPTER_MANAGER;
        if (adapterMgr != null) {
            return adapterMgr.getAdapter(this, type);
        }
        return null;
    }
}

