/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.resource;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtil {
    public static String normalize(String path) {
        if (path.length() == 0) {
            return path;
        }
        int absOffset = path.charAt(0) == '/' ? 0 : 1;
        char[] buf = new char[path.length() + 1 + absOffset];
        if (absOffset == 1) {
            buf[0] = 47;
        }
        path.getChars(0, path.length(), buf, absOffset);
        buf[buf.length - 1] = 47;
        int lastSlash = 0;
        int numDots = 0;
        int bufPos = 0;
        for (int bufIdx = lastSlash; bufIdx < buf.length; ++bufIdx) {
            int nextSlash;
            char c = buf[bufIdx];
            if (c == '/') {
                if (numDots == 2) {
                    if (bufPos == 0) {
                        return null;
                    }
                    while (--bufPos > 0 && buf[bufPos] != '/') {
                    }
                }
                lastSlash = bufIdx;
                numDots = 0;
                continue;
            }
            if (c == '.' && numDots < 2) {
                ++numDots;
                continue;
            }
            for (nextSlash = bufIdx + 1; nextSlash < buf.length && buf[nextSlash] != '/'; ++nextSlash) {
            }
            if (bufPos < lastSlash) {
                int segLen = nextSlash - bufIdx + 1;
                System.arraycopy(buf, lastSlash, buf, bufPos, segLen);
                bufPos += segLen;
            } else {
                bufPos = nextSlash;
            }
            numDots = 0;
            lastSlash = nextSlash;
            bufIdx = nextSlash;
        }
        String resolved = bufPos == 0 && numDots == 0 ? (absOffset == 0 ? "/" : "") : (bufPos - absOffset == path.length() ? path : new String(buf, absOffset, bufPos - absOffset));
        return resolved;
    }

    public static String getParent(String path) {
        if ("/".equals(path)) {
            return null;
        }
        if ((path = ResourceUtil.normalize(path)) == null || "/".equals(path)) {
            return null;
        }
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash < 0) {
            return null;
        }
        if (lastSlash == 0) {
            return "/";
        }
        return path.substring(0, lastSlash);
    }

    public static Resource getParent(Resource rsrc) {
        String parentPath = ResourceUtil.getParent(rsrc.getPath());
        if (parentPath == null) {
            return null;
        }
        return rsrc.getResourceResolver().getResource(parentPath);
    }

    public static String getName(Resource rsrc) {
        return ResourceUtil.getName(rsrc.getPath());
    }

    public static String getName(String path) {
        if ("/".equals(path)) {
            return "";
        }
        if ("/".equals(path = ResourceUtil.normalize(path))) {
            return "";
        }
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static boolean isSyntheticResource(Resource res) {
        if (res instanceof SyntheticResource) {
            return true;
        }
        if (!(res instanceof ResourceWrapper)) {
            return false;
        }
        while ((res = ((ResourceWrapper)res).getResource()) instanceof ResourceWrapper) {
        }
        return res instanceof SyntheticResource;
    }

    public static boolean isStarResource(Resource res) {
        return res.getPath().endsWith("/*");
    }

    public static boolean isNonExistingResource(Resource res) {
        return "sling:nonexisting".equals(res.getResourceType());
    }

    public static Iterator<Resource> listChildren(Resource parent) {
        return parent.getResourceResolver().listChildren(parent);
    }

    public static ValueMap getValueMap(Resource res) {
        ValueMap valueMap;
        ValueMap valueMap2 = valueMap = res != null ? res.adaptTo(ValueMap.class) : null;
        if (valueMap == null) {
            HashMap<String, Object> map;
            HashMap<String, Object> hashMap = map = res != null ? res.adaptTo(Map.class) : null;
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            valueMap = new ValueMapDecorator(map);
        }
        return valueMap;
    }

    public static String resourceTypeToPath(String type) {
        return type.replaceAll("\\:", "/");
    }

    public static String getResourceSuperType(ResourceResolver resourceResolver, String resourceType) {
        String resourceSuperType;
        block2: {
            String rtPath;
            block1: {
                rtPath = ResourceUtil.resourceTypeToPath(resourceType);
                resourceSuperType = null;
                if (rtPath == null || !rtPath.startsWith("/")) break block1;
                Resource rtResource = resourceResolver.getResource(rtPath);
                if (rtResource == null) break block2;
                resourceSuperType = rtResource.getResourceSuperType();
                break block2;
            }
            for (String searchPath : resourceResolver.getSearchPath()) {
                Resource rtResource = resourceResolver.getResource(searchPath + rtPath);
                if (rtResource == null || rtResource.getResourceSuperType() == null) continue;
                resourceSuperType = rtResource.getResourceSuperType();
                break;
            }
        }
        return resourceSuperType;
    }

    public static String findResourceSuperType(Resource resource) {
        String resourceSuperType = resource.getResourceSuperType();
        if (resourceSuperType == null) {
            resourceSuperType = ResourceUtil.getResourceSuperType(resource.getResourceResolver(), resource.getResourceType());
        }
        return resourceSuperType;
    }

    public static boolean isA(Resource resource, String resourceType) {
        if (resource == null || resourceType == null) {
            return false;
        }
        if (resourceType.equals(resource.getResourceType())) {
            return true;
        }
        String superType = ResourceUtil.findResourceSuperType(resource);
        while (superType != null) {
            if (resourceType.equals(superType)) {
                return true;
            }
            superType = ResourceUtil.getResourceSuperType(resource.getResourceResolver(), superType);
        }
        return false;
    }

    public static <T> Iterator<T> adaptTo(final Iterator<Resource> iterator, final Class<T> type) {
        return new Iterator<T>(){
            private T nextObject = this.seek();

            @Override
            public boolean hasNext() {
                return this.nextObject != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object object = this.nextObject;
                this.nextObject = this.seek();
                return object;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private T seek() {
                Object result = null;
                while (result == null && iterator.hasNext()) {
                    Resource r = (Resource)iterator.next();
                    result = r.adaptTo(type);
                }
                return result;
            }
        };
    }
}

