/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.resource.path;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class Path
implements Comparable<Path> {
    public static final String GLOB_PREFIX = "glob:";
    private final String path;
    private final String prefix;
    private final boolean isPattern;
    private final Pattern regexPattern;

    public Path(@Nonnull String path) {
        this.path = path.equals("/") ? "/" : (path.endsWith("/") ? path.substring(0, path.length() - 1) : path);
        if (this.path.startsWith(GLOB_PREFIX)) {
            int pos;
            String patternPath = path.substring(GLOB_PREFIX.length());
            this.isPattern = true;
            this.regexPattern = Pattern.compile(Path.toRegexPattern(patternPath));
            int lastSlash = 0;
            for (pos = 1; patternPath.length() > pos; ++pos) {
                char c = patternPath.charAt(pos);
                if (c == '/') {
                    lastSlash = pos;
                    continue;
                }
                if (c == '*') break;
            }
            this.prefix = pos == patternPath.length() ? patternPath : patternPath.substring(0, lastSlash + 1);
        } else {
            this.isPattern = false;
            this.regexPattern = null;
            String string = this.prefix = this.path.equals("/") ? "/" : this.path.concat("/");
        }
        if (!this.prefix.startsWith("/")) {
            throw new IllegalArgumentException("Path must be absolute: " + path);
        }
    }

    public boolean matches(String otherPath) {
        if (otherPath.startsWith(GLOB_PREFIX)) {
            int start;
            if (this.isPattern) {
                Path oPath = new Path(otherPath);
                return this.regexPattern.equals(oPath.regexPattern);
            }
            Path oPath = new Path(otherPath);
            if (this.matches(oPath.prefix)) {
                return true;
            }
            int count = 0;
            for (int i = 0; i < this.path.length(); ++i) {
                if (this.path.charAt(i) != '/') continue;
                ++count;
            }
            for (start = GLOB_PREFIX.length(); start < otherPath.length(); ++start) {
                if (otherPath.charAt(start) != '/') continue;
                if (count == 0) break;
                --count;
            }
            if (count > 0) {
                return false;
            }
            String globPattern = otherPath.substring(0, start);
            Path globPatternPath = new Path(globPattern);
            return globPatternPath.matches(this.path);
        }
        if (!otherPath.startsWith("/")) {
            throw new IllegalArgumentException("Path must be absolute: " + otherPath);
        }
        if (this.isPattern) {
            return this.regexPattern.matcher(otherPath).matches();
        }
        return this.path.equals(otherPath) || otherPath.startsWith(this.prefix);
    }

    public String getPath() {
        return this.path;
    }

    public boolean isPattern() {
        return this.isPattern;
    }

    @Override
    public int compareTo(@Nonnull Path o) {
        return this.getPath().compareTo(o.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Path)) {
            return false;
        }
        return this.getPath().equals(((Path)obj).getPath());
    }

    private static String toRegexPattern(String pattern) {
        StringBuilder stringBuilder = new StringBuilder("^");
        int index = 0;
        block4: while (index < pattern.length()) {
            char currentChar = pattern.charAt(index++);
            switch (currentChar) {
                case '*': {
                    if (Path.getCharAtIndex(pattern, index) == '*') {
                        stringBuilder.append(".*");
                        ++index;
                        continue block4;
                    }
                    stringBuilder.append("[^/]*");
                    continue block4;
                }
                case '/': {
                    stringBuilder.append(currentChar);
                    continue block4;
                }
            }
            if (Path.isRegexMeta(currentChar)) {
                stringBuilder.append(Pattern.quote(Character.toString(currentChar)));
                continue;
            }
            stringBuilder.append(currentChar);
        }
        return stringBuilder.append('$').toString();
    }

    private static char getCharAtIndex(String string, int index) {
        return index < string.length() ? string.charAt(index) : (char)'\u0000';
    }

    private static boolean isRegexMeta(char character) {
        return "<([{\\^-=$!|]})?*+.>".indexOf(character) != -1;
    }

    public String toString() {
        return "Path [path=" + this.path + "]";
    }
}

