/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.spi.resource.provider;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.spi.resource.provider.ProviderContext;
import org.apache.sling.spi.resource.provider.QueryLanguageProvider;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public abstract class ResourceProvider<T> {
    public static final String PROPERTY_ROOT = "provider.root";
    public static final String PROPERTY_NAME = "provider.name";
    public static final String PROPERTY_USE_RESOURCE_ACCESS_SECURITY = "provider.useResourceAccessSecurity";
    public static final String AUTHENTICATE_NO = "no";
    public static final String AUTHENTICATE_REQUIRED = "required";
    public static final String AUTHENTICATE_LAZY = "lazy";
    public static final String PROPERTY_AUTHENTICATE = "provider.authenticate";
    public static final String PROPERTY_MODIFIABLE = "provider.modifiable";
    public static final String PROPERTY_ADAPTABLE = "provider.adaptable";
    public static final String PROPERTY_REFRESHABLE = "provider.refreshable";
    public static final String PROPERTY_ATTRIBUTABLE = "provider.attributable";
    public static final String AUTH_SERVICE_BUNDLE = "sling.service.bundle";
    public static final String AUTH_ADMIN = "provider.auth.admin";
    public static final String RESOURCE_TYPE_SYNTHETIC = "sling:syntheticResourceProviderResource";
    private volatile ProviderContext ctx;

    public void start(@Nonnull ProviderContext ctx) {
        this.ctx = ctx;
    }

    public void stop() {
        this.ctx = null;
    }

    public void update(long changeSet) {
    }

    @CheckForNull
    protected ProviderContext getProviderContext() {
        return this.ctx;
    }

    @CheckForNull
    public T authenticate(@Nonnull Map<String, Object> authenticationInfo) throws LoginException {
        return null;
    }

    public void logout(@CheckForNull T state) {
    }

    public void refresh(@Nonnull ResolveContext<T> ctx) {
    }

    public boolean isLive(@Nonnull ResolveContext<T> ctx) {
        return true;
    }

    @CheckForNull
    public Resource getParent(@Nonnull ResolveContext<T> ctx, @Nonnull Resource child) {
        String parentPath = ResourceUtil.getParent(child.getPath());
        if (parentPath == null) {
            return null;
        }
        return this.getResource(ctx, parentPath, ResourceContext.EMPTY_CONTEXT, null);
    }

    @CheckForNull
    public abstract Resource getResource(@Nonnull ResolveContext<T> var1, @Nonnull String var2, @Nonnull ResourceContext var3, @CheckForNull Resource var4);

    @CheckForNull
    public abstract Iterator<Resource> listChildren(@Nonnull ResolveContext<T> var1, @Nonnull Resource var2);

    @CheckForNull
    public Collection<String> getAttributeNames(@Nonnull ResolveContext<T> ctx) {
        return null;
    }

    @CheckForNull
    public Object getAttribute(@Nonnull ResolveContext<T> ctx, @Nonnull String name) {
        return null;
    }

    @Nonnull
    public Resource create(@Nonnull ResolveContext<T> ctx, String path, Map<String, Object> properties) throws PersistenceException {
        throw new PersistenceException("create is not supported.");
    }

    public void delete(@Nonnull ResolveContext<T> ctx, @Nonnull Resource resource) throws PersistenceException {
        throw new PersistenceException("delete is not supported.");
    }

    public void revert(@Nonnull ResolveContext<T> ctx) {
    }

    public void commit(@Nonnull ResolveContext<T> ctx) throws PersistenceException {
    }

    public boolean hasChanges(@Nonnull ResolveContext<T> ctx) {
        return false;
    }

    @CheckForNull
    public QueryLanguageProvider<T> getQueryLanguageProvider() {
        return null;
    }

    @CheckForNull
    public <AdapterType> AdapterType adaptTo(@Nonnull ResolveContext<T> ctx, @Nonnull Class<AdapterType> type) {
        return null;
    }

    public boolean copy(@Nonnull ResolveContext<T> ctx, @Nonnull String srcAbsPath, @Nonnull String destAbsPath) throws PersistenceException {
        return false;
    }

    public boolean move(@Nonnull ResolveContext<T> ctx, @Nonnull String srcAbsPath, @Nonnull String destAbsPath) throws PersistenceException {
        return false;
    }
}

