/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.adapter;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.adapter.AdapterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SlingAdaptable
implements Adaptable {
    private static volatile AdapterManager ADAPTER_MANAGER;
    private Map<Class<?>, Object> adaptersCache;

    public static void setAdapterManager(AdapterManager adapterMgr) {
        ADAPTER_MANAGER = adapterMgr;
    }

    public static void unsetAdapterManager(AdapterManager adapterMgr) {
        if (ADAPTER_MANAGER == adapterMgr) {
            ADAPTER_MANAGER = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        Object result = null;
        SlingAdaptable slingAdaptable = this;
        synchronized (slingAdaptable) {
            if (this.adaptersCache != null) {
                result = this.adaptersCache.get(type);
            }
            if (result == null) {
                AdapterManager mgr = ADAPTER_MANAGER;
                Object object = result = mgr == null ? null : (Object)mgr.getAdapter(this, type);
                if (result != null) {
                    if (this.adaptersCache == null) {
                        this.adaptersCache = new HashMap();
                    }
                    this.adaptersCache.put(type, result);
                }
            }
        }
        return (AdapterType)result;
    }
}

