/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.resource;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtil {
    public static String normalize(String path) {
        if (path.length() == 0) {
            return path;
        }
        int absOffset = path.charAt(0) == '/' ? 0 : 1;
        char[] buf = new char[path.length() + 1 + absOffset];
        if (absOffset == 1) {
            buf[0] = 47;
        }
        path.getChars(0, path.length(), buf, absOffset);
        buf[buf.length - 1] = 47;
        int lastSlash = 0;
        int numDots = 0;
        int bufPos = 0;
        for (int bufIdx = lastSlash; bufIdx < buf.length; ++bufIdx) {
            int nextSlash;
            char c = buf[bufIdx];
            if (c == '/') {
                if (numDots == 2) {
                    if (bufPos == 0) {
                        return null;
                    }
                    while (--bufPos > 0 && buf[bufPos] != '/') {
                    }
                }
                lastSlash = bufIdx;
                numDots = 0;
                continue;
            }
            if (c == '.' && numDots < 2) {
                ++numDots;
                continue;
            }
            for (nextSlash = bufIdx + 1; nextSlash < buf.length && buf[nextSlash] != '/'; ++nextSlash) {
            }
            if (bufPos < lastSlash) {
                int segLen = nextSlash - bufIdx + 1;
                System.arraycopy(buf, lastSlash, buf, bufPos, segLen);
                bufPos += segLen;
            } else {
                bufPos = nextSlash;
            }
            numDots = 0;
            lastSlash = nextSlash;
            bufIdx = nextSlash;
        }
        String resolved = bufPos == 0 && numDots == 0 ? (absOffset == 0 ? "/" : "") : (bufPos - absOffset == path.length() ? path : new String(buf, absOffset, bufPos - absOffset));
        return resolved;
    }

    public static String getParent(String path) {
        int lastSlash;
        if ("/".equals(path)) {
            return null;
        }
        if ((path = ResourceUtil.normalize(path)) == null || "/".equals(path)) {
            return null;
        }
        String workspaceName = null;
        int wsSepPos = path.indexOf(":/");
        if (wsSepPos != -1) {
            workspaceName = path.substring(0, wsSepPos);
            path = path.substring(wsSepPos + 1);
        }
        if ((lastSlash = path.lastIndexOf(47)) < 0) {
            return null;
        }
        if (lastSlash == 0) {
            if (workspaceName != null) {
                return workspaceName + ":/";
            }
            return "/";
        }
        String parentPath = path.substring(0, lastSlash);
        if (workspaceName != null) {
            return workspaceName + ":" + parentPath;
        }
        return parentPath;
    }

    public static String getParent(String path, int level) {
        if (level < 0) {
            throw new IllegalArgumentException("level must be non-negative");
        }
        String result = path;
        for (int i = 0; i < level && (result = ResourceUtil.getParent(result)) != null; ++i) {
        }
        return result;
    }

    @Deprecated
    public static Resource getParent(Resource rsrc) {
        return rsrc.getParent();
    }

    @Deprecated
    public static String getName(Resource rsrc) {
        return ResourceUtil.getName(rsrc.getPath());
    }

    public static String getName(String path) {
        if ("/".equals(path)) {
            return "";
        }
        if ("/".equals(path = ResourceUtil.normalize(path))) {
            return "";
        }
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static boolean isSyntheticResource(Resource res) {
        if (res instanceof SyntheticResource) {
            return true;
        }
        if (!(res instanceof ResourceWrapper)) {
            return false;
        }
        while ((res = ((ResourceWrapper)res).getResource()) instanceof ResourceWrapper) {
        }
        return res instanceof SyntheticResource;
    }

    public static boolean isStarResource(Resource res) {
        return res.getPath().endsWith("/*");
    }

    public static boolean isNonExistingResource(Resource res) {
        return "sling:nonexisting".equals(res.getResourceType());
    }

    @Deprecated
    public static Iterator<Resource> listChildren(Resource parent) {
        return parent.getResourceResolver().listChildren(parent);
    }

    @Deprecated
    public static ValueMap getValueMap(Resource res) {
        if (res == null) {
            return new ValueMapDecorator(new HashMap<String, Object>());
        }
        return res.getValueMap();
    }

    public static String resourceTypeToPath(String type) {
        return type.replace(':', '/');
    }

    @Deprecated
    public static String getResourceSuperType(ResourceResolver resourceResolver, String resourceType) {
        return resourceResolver.getParentResourceType(resourceType);
    }

    @Deprecated
    public static String findResourceSuperType(Resource resource) {
        if (resource == null) {
            return null;
        }
        return resource.getResourceResolver().getParentResourceType(resource);
    }

    @Deprecated
    public static boolean isA(Resource resource, String resourceType) {
        if (resource == null) {
            return false;
        }
        return resource.getResourceResolver().isResourceType(resource, resourceType);
    }

    public static <T> Iterator<T> adaptTo(final Iterator<Resource> iterator, final Class<T> type) {
        return new Iterator<T>(){
            private T nextObject = this.seek();

            @Override
            public boolean hasNext() {
                return this.nextObject != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object object = this.nextObject;
                this.nextObject = this.seek();
                return object;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private T seek() {
                Object result = null;
                while (result == null && iterator.hasNext()) {
                    Resource r = (Resource)iterator.next();
                    result = r.adaptTo(type);
                }
                return result;
            }
        };
    }

    public static Resource getOrCreateResource(ResourceResolver resolver, String path, String resourceType, String intermediateResourceType, boolean autoCommit) throws PersistenceException {
        Map<String, Object> props = resourceType == null ? null : Collections.singletonMap("sling:resourceType", resourceType);
        return ResourceUtil.getOrCreateResource(resolver, path, props, intermediateResourceType, autoCommit);
    }

    public static Resource getOrCreateResource(ResourceResolver resolver, String path, Map<String, Object> resourceProperties, String intermediateResourceType, boolean autoCommit) throws PersistenceException {
        Resource rsrc;
        block10: {
            rsrc = resolver.getResource(path);
            if (rsrc == null) {
                Resource parentResource;
                String name;
                block9: {
                    int lastPos = path.lastIndexOf(47);
                    name = path.substring(lastPos + 1);
                    if (lastPos == 0) {
                        parentResource = resolver.getResource("/");
                    } else {
                        String parentPath = path.substring(0, lastPos);
                        parentResource = ResourceUtil.getOrCreateResource(resolver, parentPath, intermediateResourceType, intermediateResourceType, autoCommit);
                    }
                    if (autoCommit) {
                        resolver.refresh();
                    }
                    try {
                        rsrc = resolver.create(parentResource, name, resourceProperties);
                    }
                    catch (PersistenceException pe) {
                        resolver.refresh();
                        rsrc = resolver.getResource(parentResource, name);
                        if (rsrc != null) break block9;
                        throw pe;
                    }
                }
                if (autoCommit) {
                    try {
                        resolver.commit();
                        resolver.refresh();
                        rsrc = resolver.getResource(parentResource, name);
                    }
                    catch (PersistenceException pe) {
                        resolver.revert();
                        resolver.refresh();
                        rsrc = resolver.getResource(parentResource, name);
                        if (rsrc != null) break block10;
                        rsrc = resolver.create(parentResource, name, resourceProperties);
                        resolver.commit();
                    }
                }
            }
        }
        return rsrc;
    }

    public static String createUniqueChildName(Resource parent, String name) throws PersistenceException {
        if (parent.getChild(name) != null) {
            String childNodeName = null;
            int i = 0;
            do {
                childNodeName = name + String.valueOf(i);
                if (i == Integer.MAX_VALUE) {
                    String message = MessageFormat.format("can not find a unique name {0} for {1}", name, parent.getPath());
                    throw new PersistenceException(message);
                }
                ++i;
            } while (parent.getChild(childNodeName) != null);
            return childNodeName;
        }
        return name;
    }

    public static Resource unwrap(Resource rsrc) {
        Resource result = rsrc;
        while (result instanceof ResourceWrapper) {
            result = ((ResourceWrapper)result).getResource();
        }
        return result;
    }

    public static BatchResourceRemover getBatchResourceRemover(int threshold) {
        return new BatchResourceRemover(threshold);
    }

    public static class BatchResourceRemover {
        private final int max;
        private int count;

        public BatchResourceRemover(int batchSize) {
            this.max = batchSize < 1 ? 50 : batchSize;
        }

        public void delete(Resource rsrc) throws PersistenceException {
            ResourceResolver resolver = rsrc.getResourceResolver();
            for (Resource child : rsrc.getChildren()) {
                this.delete(child);
            }
            resolver.delete(rsrc);
            ++this.count;
            if (this.count >= this.max) {
                resolver.commit();
                this.count = 0;
            }
        }
    }
}

