/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bgservlets;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.sling.api.SlingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackgroundHttpServletRequest
implements HttpServletRequest {
    private static final Logger log = LoggerFactory.getLogger(BackgroundHttpServletRequest.class);
    private final String contextPath;
    private final String method;
    private final String pathInfo;
    private final String servletPath;
    private final String queryString;
    private final String requestURI;
    private final StringBuffer requestURL;
    private String characterEncoding;
    private final int contentLength;
    private final String contentType;
    private final Locale locale;
    private final String protocol;
    private final String remoteAddr;
    private final String remoteHost;
    private final int remotePort;
    private final int serverPort;
    private final String scheme;
    private final String remoteUser;
    private final String serverName;
    private final Map<String, Object> attributes;
    private final Map<String, ?> parameters;

    public BackgroundHttpServletRequest(HttpServletRequest r, String[] parametersToRemove) {
        this.contextPath = r.getContextPath();
        this.method = r.getMethod();
        this.pathInfo = r.getPathInfo();
        this.servletPath = r.getServletPath();
        this.queryString = this.filterQueryString(r.getQueryString(), parametersToRemove);
        this.requestURI = r.getRequestURI();
        this.requestURL = r.getRequestURL();
        this.characterEncoding = r.getCharacterEncoding();
        this.contentLength = r.getContentLength();
        this.contentType = r.getContentType();
        this.locale = r.getLocale();
        this.protocol = r.getProtocol();
        this.remoteAddr = r.getRemoteAddr();
        this.remoteHost = r.getRemoteHost();
        this.remotePort = r.getRemotePort();
        this.serverPort = r.getServerPort();
        this.scheme = r.getScheme();
        this.remoteUser = r.getRemoteUser();
        this.serverName = r.getServerName();
        this.attributes = new HashMap<String, Object>();
        this.parameters = new HashMap();
        this.parameters.putAll(r.getParameterMap());
        for (String key : parametersToRemove) {
            this.parameters.remove(key);
        }
    }

    private String filterQueryString(String original, String[] parametersToRemove) {
        String[] params;
        if (original == null) {
            return null;
        }
        String encoding = "UTF-8";
        StringBuilder sb = new StringBuilder(original.length());
        String SEP = "&";
        for (String param : params = original.split("&")) {
            String name = null;
            try {
                name = URLDecoder.decode(param.split("=")[0].trim(), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new SlingException("Unexpected UnsupportedEncodingException for UTF-8", (Throwable)uee);
            }
            boolean ignore = false;
            for (String p : parametersToRemove) {
                if (!name.equals(p)) continue;
                ignore = true;
                break;
            }
            if (ignore) continue;
            sb.append(param).append("&");
        }
        String result = sb.toString();
        log.debug("Filtered query string to '{}'", (Object)result);
        return result;
    }

    public String getAuthType() {
        return null;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Cookie[] getCookies() {
        return null;
    }

    public long getDateHeader(String arg0) {
        return 0L;
    }

    public String getHeader(String arg0) {
        return null;
    }

    public Enumeration<?> getHeaderNames() {
        return null;
    }

    public Enumeration<?> getHeaders(String name) {
        return null;
    }

    public int getIntHeader(String name) {
        return 0;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        throw new UnsupportedBackgroundOperationException();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public String getRequestedSessionId() {
        throw new UnsupportedBackgroundOperationException();
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        return this.requestURL;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession() {
        throw new UnsupportedBackgroundOperationException();
    }

    public HttpSession getSession(boolean arg0) {
        throw new UnsupportedBackgroundOperationException();
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedBackgroundOperationException();
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedBackgroundOperationException();
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedBackgroundOperationException();
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedBackgroundOperationException();
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedBackgroundOperationException();
    }

    public boolean isUserInRole(String arg0) {
        throw new UnsupportedBackgroundOperationException();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<?> getAttributeNames() {
        return new IteratorEnumeration<String>(this.attributes.keySet().iterator());
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    private static final String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return value;
        }
    }

    private boolean append(StringBuilder sb, String key, String val, boolean first) {
        if (!first) {
            sb.append('&');
        }
        sb.append(key);
        sb.append('=');
        sb.append(BackgroundHttpServletRequest.encode(val));
        return false;
    }

    public ServletInputStream getInputStream() throws IOException {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ?> entry : this.parameters.entrySet()) {
            if (entry.getValue() instanceof String[]) {
                for (String val : (String[])entry.getValue()) {
                    first = this.append(sb, entry.getKey(), val, first);
                }
                continue;
            }
            first = this.append(sb, entry.getKey(), (String)entry.getValue(), first);
        }
        return new ByteArrayServletInputStream(new ByteArrayInputStream(sb.toString().getBytes(this.characterEncoding)));
    }

    public String getLocalAddr() {
        throw new UnsupportedBackgroundOperationException();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration<?> getLocales() {
        throw new UnsupportedBackgroundOperationException();
    }

    public String getLocalName() {
        throw new UnsupportedBackgroundOperationException();
    }

    public int getLocalPort() {
        throw new UnsupportedBackgroundOperationException();
    }

    public String getParameter(String name) {
        Object obj = this.parameters.get(name);
        if (obj instanceof String[]) {
            return ((String[])obj)[0];
        }
        return (String)obj;
    }

    public Map<?, ?> getParameterMap() {
        return this.parameters;
    }

    public Enumeration<?> getParameterNames() {
        return new IteratorEnumeration<String>(this.parameters.keySet().iterator());
    }

    public String[] getParameterValues(String key) {
        throw new UnsupportedBackgroundOperationException();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedBackgroundOperationException();
    }

    public String getRealPath(String arg0) {
        throw new UnsupportedBackgroundOperationException();
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        throw new UnsupportedBackgroundOperationException();
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public boolean isSecure() {
        return false;
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this.characterEncoding = encoding;
    }

    private static final class ByteArrayServletInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream stream;

        public ByteArrayServletInputStream(ByteArrayInputStream stream) {
            this.stream = stream;
        }

        public int available() throws IOException {
            return this.stream.available();
        }

        public void close() throws IOException {
            this.stream.close();
        }

        public synchronized void mark(int arg0) {
            this.stream.mark(arg0);
        }

        public boolean markSupported() {
            return this.stream.markSupported();
        }

        public int read() throws IOException {
            return this.stream.read();
        }

        public int read(byte[] arg0, int arg1, int arg2) throws IOException {
            return this.stream.read(arg0, arg1, arg2);
        }

        public int read(byte[] arg0) throws IOException {
            return this.stream.read(arg0);
        }

        public synchronized void reset() throws IOException {
            this.stream.reset();
        }

        public long skip(long arg0) throws IOException {
            return this.stream.skip(arg0);
        }
    }

    class UnsupportedBackgroundOperationException
    extends UnsupportedOperationException {
        UnsupportedBackgroundOperationException() {
            super("This operation is not supported for background requests");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IteratorEnumeration<T>
    implements Enumeration<T> {
        private final Iterator<T> it;

        IteratorEnumeration(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        @Override
        public T nextElement() {
            return this.it.next();
        }
    }
}

