/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bgservlets.impl;

import java.io.IOException;
import java.util.Date;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.bgservlets.BackgroundHttpServletRequest;
import org.apache.sling.bgservlets.BackgroundHttpServletResponse;
import org.apache.sling.bgservlets.JobData;
import org.apache.sling.bgservlets.JobProgressInfo;
import org.apache.sling.bgservlets.JobStatus;
import org.apache.sling.bgservlets.JobStorage;
import org.apache.sling.bgservlets.RuntimeState;
import org.apache.sling.bgservlets.impl.SuspendableOutputStream;
import org.apache.sling.engine.SlingRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BackgroundRequestExecutionJob
implements Runnable,
JobStatus,
RuntimeState,
JobProgressInfo {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final HttpServletRequest request;
    private final BackgroundHttpServletResponse response;
    private final SuspendableOutputStream stream;
    private final ResourceResolver resourceResolver;
    private final SlingRequestProcessor slingRequestProcessor;
    private final String path;
    private final String streamPath;
    private final Date creationTime;
    private Date estimatedCompletionTime;
    private String progressMessage;

    BackgroundRequestExecutionJob(SlingRequestProcessor slingRequestProcessor, JobStorage storage, SlingHttpServletRequest request, HttpServletResponse hsr, String[] parametersToRemove) throws IOException, LoginException {
        this.request = new BackgroundHttpServletRequest((HttpServletRequest)request, parametersToRemove);
        this.slingRequestProcessor = slingRequestProcessor;
        this.request.setAttribute(RuntimeState.class.getName(), (Object)this);
        this.resourceResolver = request.getResourceResolver().clone(null);
        Session s = (Session)this.resourceResolver.adaptTo(Session.class);
        if (s == null) {
            throw new IOException("Unable to get Session from ResourceResolver " + this.resourceResolver);
        }
        JobData d = storage.createJobData(s);
        String ext = request.getRequestPathInfo().getExtension();
        if (ext != null) {
            d.setProperty("sling:jobExtension", ext);
        }
        this.path = d.getPath();
        this.creationTime = d.getCreationTime();
        this.streamPath = d.getPath() + "/stream" + (ext == null ? "" : "." + ext);
        this.stream = new SuspendableOutputStream(d.getOutputStream());
        this.response = new BackgroundHttpServletResponse(hsr, this.stream);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", state=" + (Object)((Object)this.getState()) + ", path=" + this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.slingRequestProcessor.processRequest(this.request, (HttpServletResponse)this.response, this.resourceResolver);
        }
        catch (Exception e) {
            this.log.error("Exception in background request processing", (Throwable)e);
        }
        finally {
            try {
                this.response.cleanup();
            }
            catch (IOException ioe) {
                this.log.error("ServletResponseWrapper cleanup failed", (Throwable)ioe);
            }
            this.resourceResolver.close();
        }
    }

    public String getPath() {
        return this.path;
    }

    public JobStatus.State getState() {
        return this.stream.getState();
    }

    public void requestStateChange(JobStatus.State s) {
        this.stream.requestStateChange(s);
    }

    public JobStatus.State[] getAllowedHumanStateChanges() {
        return this.stream.getAllowedHumanStateChanges();
    }

    public String getStreamPath() {
        return this.streamPath;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public JobProgressInfo getProgressInfo() {
        return this;
    }

    public String getProgressMessage() {
        return this.progressMessage;
    }

    public Date getEstimatedCompletionTime() {
        return this.estimatedCompletionTime;
    }

    public void setEstimatedCompletionTime(Date d) {
        this.estimatedCompletionTime = d;
    }

    public void setProgressMessage(String str) {
        this.progressMessage = str;
    }
}

