/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bgservlets.impl;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.bgservlets.ExecutionEngine;
import org.apache.sling.bgservlets.JobStorage;
import org.apache.sling.bgservlets.impl.BackgroundRequestExecutionJob;
import org.apache.sling.engine.SlingRequestProcessor;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="%BackgroundServletStarterFilter.label", description="%BackgroundServletStarterFilter.description")
@Service
@Properties(value={@Property(name="filter.scope", value={"request"}, propertyPrivate=true), @Property(name="filter.order", intValue={-1000000000}, propertyPrivate=true)})
public class BackgroundServletStarterFilter
implements Filter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private ExecutionEngine executionEngine;
    @Reference
    private SlingRequestProcessor slingRequestProcessor;
    @Reference
    private JobStorage jobStorage;
    @Property(value={"sling:bg"})
    public static final String PROP_BG_PARAM = "background.parameter.name";
    private String bgParamName;

    protected void activate(ComponentContext ctx) {
        this.bgParamName = (String)ctx.getProperties().get(PROP_BG_PARAM);
        if (this.bgParamName == null || this.bgParamName.length() == 0) {
            throw new IllegalStateException("Missing background.parameter.name in ComponentContext");
        }
        this.log.info("Request parameter {} will run servlets in the background", (Object)this.bgParamName);
    }

    public void doFilter(ServletRequest sreq, ServletResponse sresp, FilterChain chain) throws IOException, ServletException {
        if (!(sreq instanceof HttpServletRequest)) {
            throw new ServletException("request is not an HttpServletRequest: " + sresp.getClass().getName());
        }
        if (!(sresp instanceof HttpServletResponse)) {
            throw new ServletException("response is not an HttpServletResponse: " + sresp.getClass().getName());
        }
        HttpServletRequest request = (HttpServletRequest)sreq;
        SlingHttpServletRequest slingRequest = request instanceof SlingHttpServletRequest ? (SlingHttpServletRequest)request : null;
        HttpServletResponse response = (HttpServletResponse)sresp;
        String bgParam = sreq.getParameter(this.bgParamName);
        if (Boolean.valueOf(bgParam).booleanValue()) {
            try {
                BackgroundRequestExecutionJob job = new BackgroundRequestExecutionJob(this.slingRequestProcessor, this.jobStorage, slingRequest, response, new String[]{this.bgParamName});
                this.log.debug("{} parameter true, running request in the background ({})", (Object)this.bgParamName, (Object)job);
                if (slingRequest != null) {
                    slingRequest.getRequestProgressTracker().log(this.bgParamName + " parameter true, running request in background (" + job + ")");
                }
                this.executionEngine.queueForExecution(job);
                String ext = slingRequest.getRequestPathInfo().getExtension();
                if (ext == null) {
                    ext = "";
                } else if (ext.length() > 0) {
                    ext = "." + ext;
                }
                String path = request.getContextPath() + job.getPath() + ext;
                response.sendRedirect(path);
            }
            catch (LoginException e) {
                throw new ServletException("LoginException in doFilter", (Throwable)e);
            }
        } else {
            chain.doFilter(sreq, sresp);
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig cfg) throws ServletException {
    }

    protected void bindExecutionEngine(ExecutionEngine executionEngine) {
        this.executionEngine = executionEngine;
    }

    protected void unbindExecutionEngine(ExecutionEngine executionEngine) {
        if (this.executionEngine == executionEngine) {
            this.executionEngine = null;
        }
    }

    protected void bindSlingRequestProcessor(SlingRequestProcessor slingRequestProcessor) {
        this.slingRequestProcessor = slingRequestProcessor;
    }

    protected void unbindSlingRequestProcessor(SlingRequestProcessor slingRequestProcessor) {
        if (this.slingRequestProcessor == slingRequestProcessor) {
            this.slingRequestProcessor = null;
        }
    }

    protected void bindJobStorage(JobStorage jobStorage) {
        this.jobStorage = jobStorage;
    }

    protected void unbindJobStorage(JobStorage jobStorage) {
        if (this.jobStorage == jobStorage) {
            this.jobStorage = null;
        }
    }
}

