/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bgservlets.impl;

import java.util.Iterator;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.bgservlets.ExecutionEngine;
import org.apache.sling.bgservlets.JobConsole;
import org.apache.sling.bgservlets.JobStatus;
import org.apache.sling.bgservlets.impl.storage.JobStorageException;
import org.apache.sling.bgservlets.impl.storage.NodeJobStatusFactory;
import org.apache.sling.bgservlets.impl.webconsole.JobConsolePlugin;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="%JobConsoleImpl.label", description="%JobConsoleImpl.description")
@Service
public class JobConsoleImpl
implements JobConsole {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String JOB_QUERY = "select * from sling:bgJobData order by jcr:created desc";
    @Reference
    private ExecutionEngine executionEngine;
    @Reference
    private NodeJobStatusFactory jobStatusFactory;
    @Property(boolValue={true})
    private static final String PROP_CONSOLE_PLUGIN_ACTIVE = "console.plugin.active";

    @Override
    public Iterator<JobStatus> getJobStatus(Session session, boolean activeOnly) {
        if (activeOnly) {
            this.log.debug("activeOnly is set, getting jobs from ExecutionEngine");
            return this.getEngineJobs();
        }
        this.log.debug("activeOnly is set, getting jobs from repository query");
        try {
            return this.getStoredJobs(session);
        }
        catch (RepositoryException re) {
            throw new JobStorageException("RepositoryException in getJobStatus(query)", re);
        }
    }

    @Activate
    protected void activate(ComponentContext ctx) {
        boolean pluginActive;
        Object obj = ctx.getProperties().get(PROP_CONSOLE_PLUGIN_ACTIVE);
        boolean bl = pluginActive = obj instanceof Boolean ? (Boolean)obj : true;
        if (pluginActive) {
            JobConsolePlugin.initPlugin(ctx.getBundleContext(), this);
        } else {
            this.log.info("{} is false, not activating JobConsolePlugin", (Object)PROP_CONSOLE_PLUGIN_ACTIVE);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        JobConsolePlugin.destroyPlugin();
    }

    @Override
    public JobStatus getJobStatus(Session session, String path) {
        JobStatus result = this.executionEngine.getJobStatus(path);
        if (result == null) {
            try {
                Item i;
                if (session.itemExists(path) && (i = session.getItem(path)).isNode()) {
                    result = this.jobStatusFactory.getJobStatus((Node)i);
                }
            }
            catch (RepositoryException re) {
                throw new JobStorageException("RepositoryException in getJobStatus(path)", re);
            }
        }
        return result;
    }

    private Iterator<JobStatus> getEngineJobs() {
        return this.executionEngine.getMatchingJobStatus(null);
    }

    private Iterator<JobStatus> getStoredJobs(Session s) throws RepositoryException {
        Query q = s.getWorkspace().getQueryManager().createQuery(JOB_QUERY, "sql");
        final NodeIterator it = q.execute().getNodes();
        return new Iterator<JobStatus>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public JobStatus next() {
                try {
                    return JobConsoleImpl.this.jobStatusFactory.getJobStatus(it.nextNode());
                }
                catch (RepositoryException re) {
                    throw new JobStorageException("RepositoryException in next()", re);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public String getJobStatusPagePath(HttpServletRequest request, JobStatus jobStatus, String extension) {
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        return request.getContextPath() + jobStatus.getPath() + extension;
    }

    @Override
    public String getJobStreamPath(HttpServletRequest request, JobStatus jobStatus) {
        return request.getContextPath() + jobStatus.getStreamPath();
    }

    protected void bindExecutionEngine(ExecutionEngine executionEngine) {
        this.executionEngine = executionEngine;
    }

    protected void unbindExecutionEngine(ExecutionEngine executionEngine) {
        if (this.executionEngine == executionEngine) {
            this.executionEngine = null;
        }
    }

    protected void bindJobStatusFactory(NodeJobStatusFactory nodeJobStatusFactory) {
        this.jobStatusFactory = nodeJobStatusFactory;
    }

    protected void unbindJobStatusFactory(NodeJobStatusFactory nodeJobStatusFactory) {
        if (this.jobStatusFactory == nodeJobStatusFactory) {
            this.jobStatusFactory = null;
        }
    }
}

