/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bgservlets.impl.nodestream;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.sling.bgservlets.impl.nodestream.NodeStreamPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeInputStream
extends InputStream {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Node node;
    private final NodeStreamPath streamPath;
    private InputStream currentStream;

    public NodeInputStream(Node n) throws IOException {
        this.node = n;
        this.streamPath = new NodeStreamPath();
        this.selectNextStream();
    }

    private void selectNextStream() throws IOException {
        this.streamPath.selectNextPath();
        String propertyPath = this.streamPath.getNodePath() + "/" + "stream";
        try {
            if (this.node.hasProperty(propertyPath)) {
                Property p = this.node.getProperty(propertyPath);
                this.currentStream = p.getStream();
                this.log.debug("Switched to the InputStream of Property {}", (Object)p.getPath());
            } else {
                this.currentStream = null;
                this.log.debug("Property {} not found, end of stream", (Object)(this.node.getPath() + "/" + propertyPath));
            }
        }
        catch (RepositoryException re) {
            throw (IOException)new IOException("RepositoryException in selectNextProperty()").initCause(re);
        }
    }

    public int available() throws IOException {
        return this.currentStream == null ? 0 : this.currentStream.available();
    }

    public void close() throws IOException {
        if (this.currentStream != null) {
            this.currentStream.close();
        }
        super.close();
    }

    public int read() throws IOException {
        if (this.currentStream == null) {
            return -1;
        }
        int result = this.currentStream.read();
        if (result == -1) {
            this.selectNextStream();
            return this.read();
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.currentStream == null) {
            return 0;
        }
        int result = this.currentStream.read(b, off, len);
        if (result <= 0) {
            this.selectNextStream();
            return this.read(b, off, len);
        }
        return result;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

