/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bgservlets.impl.nodestream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.bgservlets.impl.DeepNodeCreator;
import org.apache.sling.bgservlets.impl.nodestream.NodeStreamPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeOutputStream
extends OutputStream {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String STREAM_NODE_TYPE = "nt:unstructured";
    private final Node node;
    private final NodeStreamPath streamPath;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream(32768);
    public static final int BUFFER_SIZE = 32768;
    public static final int BUFFER_SWITCH_SIZE = 36408;

    public NodeOutputStream(Node n) {
        this.node = n;
        this.streamPath = new NodeStreamPath();
    }

    public void close() throws IOException {
        this.flush();
        this.buffer.close();
    }

    public void flush() throws IOException {
        this.streamPath.selectNextPath();
        try {
            if (!this.node.getSession().isLive()) {
                this.log.warn("Session closed, unable to flush stream");
            } else {
                String streamNodePath = this.node.getPath() + "/" + this.streamPath.getNodePath();
                Node streamNode = new DeepNodeCreator().deepCreateNode(streamNodePath, this.node.getSession(), STREAM_NODE_TYPE);
                streamNode.setProperty("stream", (InputStream)new ByteArrayInputStream(this.buffer.toByteArray()));
                this.log.debug("Saved {} bytes to Property {}", (Object)this.buffer.size(), (Object)streamNode.getProperty("stream").getPath());
                this.node.save();
                this.buffer.reset();
            }
        }
        catch (RepositoryException re) {
            throw (IOException)new IOException("RepositoryException in flush()").initCause(re);
        }
    }

    private void flushIfNeeded() throws IOException {
        if (this.buffer.size() >= 36408) {
            this.log.debug("Buffer size {} reached switch level {}, flushing", (Object)this.buffer.size(), (Object)36408);
            this.flush();
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.buffer.write(b, off, len);
        this.flushIfNeeded();
    }

    public void write(byte[] b) throws IOException {
        this.buffer.write(b);
        this.flushIfNeeded();
    }

    public void write(int b) throws IOException {
        this.buffer.write(b);
        this.flushIfNeeded();
    }
}

