/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bgservlets.impl.servlets;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.bgservlets.JobData;
import org.apache.sling.bgservlets.JobStorage;

@Component
@Service
@Property(name="sling.servlet.resourceTypes", value={"sling/bg/stream"})
public class JobStreamServlet
extends SlingSafeMethodsServlet {
    @Reference
    private JobStorage jobStorage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Node n = (Node)request.getResource().adaptTo(Node.class);
        if (n == null) {
            response.sendError(404, "Resource does not adapt to a Node: " + request.getResource().getPath());
        }
        try {
            JobData d = this.jobStorage.getJobData(n.getParent());
            InputStream is = d.getInputStream();
            try {
                response.setContentType(request.getResponseContentType());
                ServletOutputStream os = response.getOutputStream();
                byte[] buffer = new byte[32768];
                int count = 0;
                while ((count = is.read(buffer, 0, buffer.length)) > 0) {
                    os.write(buffer, 0, count);
                }
                os.flush();
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (RepositoryException re) {
            throw new ServletException("RepositoryException in doGet()", (Throwable)re);
        }
    }

    protected void bindJobStorage(JobStorage jobStorage) {
        this.jobStorage = jobStorage;
    }

    protected void unbindJobStorage(JobStorage jobStorage) {
        if (this.jobStorage == jobStorage) {
            this.jobStorage = null;
        }
    }
}

