/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bgservlets.impl.storage;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.bgservlets.JobData;
import org.apache.sling.bgservlets.impl.nodestream.NodeInputStream;
import org.apache.sling.bgservlets.impl.nodestream.NodeOutputStream;
import org.apache.sling.bgservlets.impl.storage.JobStorageException;

class JobDataImpl
implements JobData {
    private final Node node;
    private final String path;
    private final Calendar creationTime;
    public static final String STREAM_PATH = "/stream".substring(1);
    public static final String RT_PROP = "sling:resourceType";

    JobDataImpl(Node n) throws RepositoryException {
        this.node = n;
        this.path = this.node.getPath();
        if (this.node.hasProperty("jcr:created")) {
            this.creationTime = this.node.getProperty("jcr:created").getDate();
        } else {
            this.creationTime = Calendar.getInstance();
            this.creationTime.set(1900, 1, 1);
        }
    }

    public InputStream getInputStream() {
        try {
            if (this.node.hasNode(STREAM_PATH)) {
                return new NodeInputStream(this.node.getNode(STREAM_PATH));
            }
        }
        catch (Exception e) {
            throw new JobStorageException("Exception in getInputStream()", e);
        }
        return null;
    }

    public OutputStream getOutputStream() {
        try {
            if (this.node.hasNode(STREAM_PATH)) {
                throw new IllegalArgumentException("Stream node already exists: " + this.node.getPath() + "/" + STREAM_PATH);
            }
            this.node.setProperty(RT_PROP, "sling/bg/job");
            Node stream = this.node.addNode(STREAM_PATH);
            stream.setProperty(RT_PROP, "sling/bg/stream");
            this.node.save();
            return new NodeOutputStream(stream);
        }
        catch (Exception e) {
            throw new JobStorageException("Exception in getOutputStream()", e);
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getProperty(String name) {
        String result = null;
        try {
            if (this.node.hasProperty(name)) {
                result = this.node.getProperty(name).getValue().getString();
            }
        }
        catch (RepositoryException re) {
            throw new JobStorageException("RepositoryException in getProperty", re);
        }
        return result;
    }

    public void setProperty(String name, String value) {
        try {
            this.node.setProperty(name, value);
            this.node.save();
        }
        catch (RepositoryException re) {
            throw new JobStorageException("RepositoryException in setProperty", re);
        }
    }

    public Date getCreationTime() {
        return this.creationTime.getTime();
    }
}

