/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bgservlets.impl.webconsole;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.sling.bgservlets.JobConsole;
import org.apache.sling.bgservlets.JobStatus;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobConsolePlugin {
    private static final Logger log = LoggerFactory.getLogger(JobConsolePlugin.class);
    private static Plugin plugin;
    public static final String LABEL = "bgservlets";
    public static final String TITLE = "Background Servlets & Jobs";
    public static final String STATUS_EXTENSION = "html";

    public static void initPlugin(BundleContext context, JobConsole jobConsole) {
        if (plugin == null) {
            Plugin tmp = new Plugin(jobConsole);
            tmp.activate(context);
            plugin = tmp;
            log.info("{} activated", (Object)plugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyPlugin() {
        if (plugin != null) {
            try {
                plugin.deactivate();
                log.info("{} deactivated", (Object)plugin);
            }
            finally {
                plugin = null;
            }
        }
    }

    public static final class Plugin
    extends AbstractWebConsolePlugin {
        private ServiceRegistration serviceRegistration;
        private final JobConsole jobConsole;
        private ServiceTracker repositoryTracker;

        public Plugin(JobConsole console) {
            this.jobConsole = console;
        }

        public void activate(BundleContext ctx) {
            super.activate(ctx);
            this.repositoryTracker = new ServiceTracker(ctx, SlingRepository.class.getName(), null);
            this.repositoryTracker.open();
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("service.description", "Web Console Plugin to display Background servlets and ExecutionEngine status");
            ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
            ((Dictionary)props).put("service.pid", ((Object)((Object)this)).getClass().getName());
            ((Dictionary)props).put("felix.webconsole.label", JobConsolePlugin.LABEL);
            this.serviceRegistration = ctx.registerService("javax.servlet.Servlet", (Object)this, props);
        }

        public void deactivate() {
            if (this.serviceRegistration != null) {
                this.serviceRegistration.unregister();
                this.serviceRegistration = null;
            }
            if (this.repositoryTracker != null) {
                this.repositoryTracker.close();
                this.repositoryTracker = null;
            }
            super.deactivate();
        }

        public String getLabel() {
            return JobConsolePlugin.LABEL;
        }

        public String getTitle() {
            return JobConsolePlugin.TITLE;
        }

        protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            PrintWriter pw = res.getWriter();
            SlingRepository repository = (SlingRepository)this.repositoryTracker.getService();
            if (repository == null) {
                pw.println("No SlingRepository service found");
                return;
            }
            Session s = null;
            try {
                s = repository.loginAdministrative(repository.getDefaultWorkspace());
                this.processCommands(req, pw, s, this.jobConsole);
                this.renderJobs(req, pw, s, this.jobConsole);
            }
            catch (RepositoryException re) {
                throw new ServletException("RepositoryExceptio in renderContent()", (Throwable)re);
            }
            finally {
                if (s != null) {
                    s.logout();
                }
            }
        }

        private void processCommands(HttpServletRequest req, PrintWriter pw, Session s, JobConsole console) {
            JobStatus job;
            String jobPath = req.getParameter("jobPath");
            if (jobPath != null && (job = console.getJobStatus(s, jobPath)) != null) {
                String action = req.getParameter("action");
                if ("suspend".equals(action)) {
                    job.requestStateChange(JobStatus.State.SUSPENDED);
                } else if ("stop".equals(action)) {
                    job.requestStateChange(JobStatus.State.STOPPED);
                } else if ("resume".equals(action)) {
                    job.requestStateChange(JobStatus.State.RUNNING);
                }
            }
        }

        private void renderJobs(HttpServletRequest req, PrintWriter pw, Session s, JobConsole console) {
            pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
            pw.println("<thead>");
            pw.println("<tr class='content'>");
            pw.println("<th class='content container'>Controls</th>");
            pw.println("<th class='content container'>State</th>");
            pw.println("<th class='content container'>ETA</th>");
            pw.println("<th class='content container'>Progress</th>");
            pw.println("<th class='content container'>Path</th>");
            pw.println("</tr>");
            pw.println("</thead>");
            pw.println("<tbody>");
            int maxJobsDisplayed = 100;
            boolean truncated = false;
            boolean activeOnly = false;
            Iterator<JobStatus> it = console.getJobStatus(s, false);
            int count = 0;
            while (it.hasNext()) {
                this.renderJobStatus(req, pw, console, it.next());
                if (++count <= 100) continue;
                truncated = true;
                break;
            }
            pw.println("</tbody>");
            pw.println("</table>");
            pw.println("Total <b>" + count + "</b> jobs.<br />");
            if (truncated) {
                pw.println("(List truncated after 100 jobs)<br />");
            }
        }

        private void renderJobStatus(HttpServletRequest request, PrintWriter pw, JobConsole console, JobStatus job) {
            String[] actions;
            pw.println("<tr class='content'>");
            pw.println("<td><form action='./bgservlets' method='GET'>");
            for (String action : actions = new String[]{"suspend", "resume", "stop"}) {
                pw.println("<input type='submit' name='action' value='" + action + "'/>&nbsp;");
            }
            pw.println("<input type='hidden' name='jobPath' value='" + job.getPath() + "'/>&nbsp;");
            pw.println("</form></td>");
            pw.println("<td>");
            pw.println(Plugin.escape(job.getState().toString()));
            pw.println("</td>");
            pw.println("<td>");
            Date eta = job.getProgressInfo().getEstimatedCompletionTime();
            pw.println(eta == null ? "-" : eta.toString());
            pw.println("</td>");
            pw.println("<td>");
            pw.println(Plugin.escape(job.getProgressInfo().getProgressMessage()));
            pw.println("</td>");
            pw.print("<td>\n<a href='");
            pw.print(Plugin.escape(console.getJobStatusPagePath(request, job, JobConsolePlugin.STATUS_EXTENSION)));
            pw.print("'>");
            pw.print(Plugin.escape(job.getPath()));
            pw.println("</a>");
            pw.println("</td>");
            pw.println("</tr>");
        }

        static String escape(String str) {
            if (str == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c == '<') {
                    sb.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    sb.append("&gt;");
                    continue;
                }
                if (c == '&') {
                    sb.append("&amp;");
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }
    }
}

