/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.resource.spi;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class ContextResource {
    private final Resource resource;
    private final String configRef;
    private final int serviceRanking;
    private final String key;

    public ContextResource(@Nonnull Resource resource, String configRef, int serviceRanking) {
        this.resource = resource;
        this.configRef = configRef;
        this.serviceRanking = serviceRanking;
        this.key = resource.getPath() + "|" + configRef;
    }

    @Deprecated
    public ContextResource(@Nonnull Resource resource, String configRef) {
        this(resource, configRef, 0);
    }

    @Nonnull
    public Resource getResource() {
        return this.resource;
    }

    @CheckForNull
    public String getConfigRef() {
        return this.configRef;
    }

    public int getServiceRanking() {
        return this.serviceRanking;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ContextResource) {
            return StringUtils.equals((CharSequence)this.key, (CharSequence)((ContextResource)obj).key);
        }
        return false;
    }
}

