/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.compiler.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.commons.compiler.CompilationResult;
import org.apache.sling.commons.compiler.CompilerMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationResultImpl
implements CompilationResult {
    private List<CompilerMessage> errors;
    private List<CompilerMessage> warnings;
    private final boolean ignoreWarnings;
    private final boolean compilationRequired;
    private final ClassLoader classLoader;

    public CompilationResultImpl(String errorMessage) {
        this.ignoreWarnings = true;
        this.classLoader = null;
        this.compilationRequired = false;
        this.onError(errorMessage, "<General>", 0, 0);
    }

    public CompilationResultImpl(ClassLoader classLoader) {
        this.ignoreWarnings = true;
        this.classLoader = classLoader;
        this.compilationRequired = false;
    }

    public CompilationResultImpl(boolean ignoreWarnings, ClassLoader classLoader) {
        this.ignoreWarnings = ignoreWarnings;
        this.classLoader = classLoader;
        this.compilationRequired = true;
    }

    @Override
    public List<CompilerMessage> getErrors() {
        return this.errors;
    }

    @Override
    public List<CompilerMessage> getWarnings() {
        return this.warnings;
    }

    @Override
    public Class<?> loadCompiledClass(String className) throws ClassNotFoundException {
        if (this.errors != null) {
            throw new ClassNotFoundException(className);
        }
        return this.classLoader.loadClass(className);
    }

    @Override
    public boolean didCompile() {
        return this.compilationRequired;
    }

    public void onError(String msg, String sourceFile, int line, int position) {
        if (this.errors == null) {
            this.errors = new ArrayList<CompilerMessage>();
        }
        this.errors.add(new CompilerMessage(sourceFile, line, position, msg));
    }

    public void onWarning(String msg, String sourceFile, int line, int position) {
        if (!this.ignoreWarnings) {
            if (this.warnings == null) {
                this.warnings = new ArrayList<CompilerMessage>();
            }
            this.warnings.add(new CompilerMessage(sourceFile, line, position, msg));
        }
    }
}

