/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.compiler.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import org.apache.sling.commons.classloader.ClassLoaderWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IsolatedClassLoader
extends SecureClassLoader {
    private final ClassLoaderWriter classLoaderWriter;

    public IsolatedClassLoader(ClassLoader parent, ClassLoaderWriter classLoaderWriter) {
        super(parent);
        this.classLoaderWriter = classLoaderWriter;
    }

    @Override
    public final Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            try {
                clazz = this.findClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                ClassLoader parent = this.getParent();
                if (parent != null) {
                    clazz = parent.loadClass(name);
                }
                throw cnfe;
            }
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    protected Class<?> findClass(final String name) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws ClassNotFoundException {
                    return IsolatedClassLoader.this.findClassPrivileged(name);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
    }

    private Class<?> findClassPrivileged(String name) throws ClassNotFoundException {
        String path = "/" + name.replace('.', '/') + ".class";
        InputStream is = null;
        try {
            is = this.classLoaderWriter.getInputStream(path);
            Class<?> c = this.defineClass(name, is);
            if (c == null) {
                throw new ClassNotFoundException(name);
            }
            return c;
        }
        catch (ClassNotFoundException cnfe) {
            throw cnfe;
        }
        catch (Throwable t) {
            throw new ClassNotFoundException(name, t);
        }
    }

    private Class<?> defineClass(String name, InputStream is) throws IOException {
        int l;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        while ((l = is.read(buffer)) >= 0) {
            baos.write(buffer, 0, l);
        }
        byte[] data = baos.toByteArray();
        return this.defineClass(name, data, 0, data.length);
    }
}

