/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.html.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.cyberneko.html.HTMLConfiguration;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class NekohtmlSaxParser
extends AbstractSAXParser {
    public NekohtmlSaxParser(Properties properties) {
        super(NekohtmlSaxParser.getConfig(properties));
    }

    protected static HTMLConfiguration getConfig(Properties properties) {
        HTMLConfiguration config = new HTMLConfiguration();
        config.setProperty("http://cyberneko.org/html/properties/names/elems", "lower");
        if (properties != null) {
            Iterator<Object> i = properties.keySet().iterator();
            while (i.hasNext()) {
                String name = i.next().toString();
                config.setProperty(name, properties.getProperty(name));
            }
        }
        return config;
    }

    public static void parse(InputStream stream, String encoding, ContentHandler ch) throws SAXException {
        NekohtmlSaxParser parser = new NekohtmlSaxParser(null);
        parser.setContentHandler(ch);
        if (ch instanceof LexicalHandler) {
            parser.setLexicalHandler((LexicalHandler)((Object)ch));
        }
        InputSource is = new InputSource(stream);
        if (encoding != null) {
            is.setEncoding(encoding);
        }
        try {
            parser.parse(is);
        }
        catch (IOException ioe) {
            throw new SAXException("Error during parsing of html markup.", ioe);
        }
    }
}

