/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.html.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sling.commons.html.HtmlParser;
import org.apache.sling.commons.html.internal.DOMBuilder;
import org.apache.sling.commons.html.internal.TagsoupHtmlParserConfiguration;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.ccil.cowan.tagsoup.Parser;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.Designate;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

@Component(property={"dom=tagsoup", "sax=tagsoup"})
@Designate(ocd=TagsoupHtmlParserConfiguration.class)
public class TagsoupHtmlParser
implements HtmlParser {
    private Map<String, Boolean> features = Collections.synchronizedMap(new LinkedHashMap());

    @Activate
    private void activate(TagsoupHtmlParserConfiguration configuration) {
        this.configure(configuration);
    }

    @Modified
    private void modified(TagsoupHtmlParserConfiguration configuration) {
        this.configure(configuration);
    }

    @Deactivate
    private void deactivate() {
        this.features.clear();
    }

    private void configure(TagsoupHtmlParserConfiguration configuration) {
        this.features.clear();
        Map map = PropertiesUtil.toMap((Object)configuration.parser_features(), (String[])new String[0]);
        for (String key : map.keySet()) {
            this.features.put(key, Boolean.valueOf((String)map.get(key)));
        }
    }

    @Override
    public void parse(InputStream stream, String encoding, ContentHandler contentHandler) throws SAXException {
        Parser parser = this.buildParser(this.features, contentHandler);
        InputSource source = new InputSource(stream);
        source.setEncoding(encoding);
        try {
            parser.parse(source);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    @Override
    public Document parse(String systemId, InputStream stream, String encoding) throws IOException {
        DOMBuilder builder = new DOMBuilder();
        InputSource source = new InputSource(stream);
        source.setEncoding(encoding);
        source.setSystemId(systemId);
        try {
            Parser parser = this.buildParser(this.features, builder);
            parser.parse(source);
        }
        catch (SAXException se) {
            if (se.getCause() instanceof IOException) {
                throw (IOException)se.getCause();
            }
            throw new IOException("Unable to parse HTML", se);
        }
        return builder.getDocument();
    }

    private Parser buildParser(Map<String, Boolean> features, ContentHandler contentHandler) throws SAXException {
        Parser parser = new Parser();
        parser.setContentHandler(contentHandler);
        if (contentHandler instanceof LexicalHandler) {
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", contentHandler);
        }
        for (String key : features.keySet()) {
            parser.setFeature(key, features.get(key));
        }
        return parser;
    }
}

