/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.json.sling;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.sling.api.request.RecursionTooDeepException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.sling.JsonObjectCreator;

public class ResourceTraversor {
    private long count;
    private long maxResources;
    private final int maxRecursionLevels;
    private final JSONObject startObject;
    private LinkedList<Entry> currentQueue;
    private LinkedList<Entry> nextQueue;
    private final Resource startResource;

    public ResourceTraversor(int levels, long maxResources, Resource resource, boolean tidy) throws JSONException {
        this.maxResources = maxResources;
        this.maxRecursionLevels = levels;
        this.startResource = resource;
        this.currentQueue = new LinkedList();
        this.nextQueue = new LinkedList();
        this.startObject = this.adapt(resource);
    }

    public int collectResources() throws RecursionTooDeepException, JSONException {
        return this.collectChildren(this.startResource, this.startObject, 0);
    }

    private int collectChildren(Resource resource, JSONObject jsonObj, int currentLevel) throws JSONException {
        if (this.maxRecursionLevels == -1 || currentLevel < this.maxRecursionLevels) {
            Iterator children = ResourceUtil.listChildren((Resource)resource);
            while (children.hasNext()) {
                ++this.count;
                Resource res = (Resource)children.next();
                if (this.count > this.maxResources && this.maxRecursionLevels != 1) {
                    return currentLevel;
                }
                JSONObject json = this.collectResource(res, jsonObj);
                this.nextQueue.addLast(new Entry(res, json));
            }
        }
        if (currentLevel > 0) {
            return -1;
        }
        while (!this.currentQueue.isEmpty() || !this.nextQueue.isEmpty()) {
            if (this.currentQueue.isEmpty()) {
                ++currentLevel;
                this.currentQueue = this.nextQueue;
                this.nextQueue = new LinkedList();
            }
            Entry nextResource = this.currentQueue.removeFirst();
            int maxLevel = this.collectChildren(nextResource.resource, nextResource.json, currentLevel);
            if (maxLevel == -1) continue;
            return maxLevel;
        }
        return -1;
    }

    private JSONObject collectResource(Resource resource, JSONObject parent) throws JSONException {
        JSONObject o = this.adapt(resource);
        parent.put(ResourceUtil.getName((Resource)resource), o);
        return o;
    }

    private JSONObject adapt(Resource resource) throws JSONException {
        return JsonObjectCreator.create(resource, 0);
    }

    public long getCount() {
        return this.count;
    }

    public JSONObject getJSONObject() {
        return this.startObject;
    }

    public static final class Entry {
        public final Resource resource;
        public final JSONObject json;

        public Entry(Resource r, JSONObject o) {
            this.resource = r;
            this.json = o;
        }
    }
}

