/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.commons.log.internal.LogManager;
import org.apache.sling.commons.log.internal.LogReaderServiceFactory;
import org.apache.sling.commons.log.internal.LogServiceFactory;
import org.apache.sling.commons.log.internal.LogSupport;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;

public class Activator
implements BundleActivator {
    private LogManager logManager;
    private LogSupport logSupport;

    public void start(BundleContext context) throws Exception {
        this.logManager = new LogManager(context);
        this.logSupport = new LogSupport();
        context.addBundleListener((BundleListener)this.logSupport);
        context.addFrameworkListener((FrameworkListener)this.logSupport);
        context.addServiceListener((ServiceListener)this.logSupport);
        LogServiceFactory lsf = new LogServiceFactory(this.logSupport);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", lsf.getClass().getName());
        ((Dictionary)props).put("service.description", "Apache Sling LogService implementation");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        context.registerService(LogService.class.getName(), (Object)lsf, props);
        LogReaderServiceFactory lrsf = new LogReaderServiceFactory(this.logSupport);
        props = new Hashtable();
        ((Dictionary)props).put("service.pid", lrsf.getClass().getName());
        ((Dictionary)props).put("service.description", "Apache Sling LogReaderService implementation");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        context.registerService(LogReaderService.class.getName(), (Object)lrsf, props);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.logSupport != null) {
            this.logSupport.shutdown();
            this.logSupport = null;
        }
        if (this.logManager != null) {
            this.logManager.shutdown();
            this.logManager = null;
        }
    }
}

