/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.commons.log.internal.LogServiceFactory;
import org.apache.sling.commons.log.internal.slf4j.LogConfigManager;
import org.apache.sling.commons.log.internal.slf4j.SlingLogPanel;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogManager {
    public static final String LOG_LEVEL = "org.apache.sling.commons.log.level";
    public static final String LOG_FILE = "org.apache.sling.commons.log.file";
    public static final String LOG_FILE_NUMBER = "org.apache.sling.commons.log.file.number";
    public static final String LOG_FILE_SIZE = "org.apache.sling.commons.log.file.size";
    public static final String LOG_PATTERN = "org.apache.sling.commons.log.pattern";
    public static final String LOG_PATTERN_DEFAULT = "{0,date,dd.MM.yyyy HH:mm:ss.SSS} *{4}* [{2}] {3} {5}";
    public static final String LOG_LOGGERS = "org.apache.sling.commons.log.names";
    public static final String LOG_LEVEL_DEFAULT = "INFO";
    public static final int LOG_FILE_NUMBER_DEFAULT = 5;
    public static final String LOG_FILE_SIZE_DEFAULT = "'.'yyyy-MM-dd";
    public static final String PID = "org.apache.sling.commons.log.LogManager";
    public static final String FACTORY_PID_WRITERS = "org.apache.sling.commons.log.LogManager.factory.writer";
    public static final String FACTORY_PID_CONFIGS = "org.apache.sling.commons.log.LogManager.factory.config";
    private final LogConfigManager logConfigManager = LogConfigManager.getInstance();
    private Logger log;
    private ServiceRegistration loggingConfigurable;
    private ServiceRegistration writerConfigurer;
    private ServiceRegistration configConfigurer;

    LogManager(BundleContext context) throws ConfigurationException {
        this.logConfigManager.setRoot(context.getProperty("sling.home"));
        GlobalConfigurator globalConfigurator = new GlobalConfigurator(this.logConfigManager, this.getBundleConfiguration(context));
        globalConfigurator.updated(null);
        this.log = LoggerFactory.getLogger(LogServiceFactory.class);
        this.log.info("LogManager: Logging set up from context");
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("service.pid", PID);
        ((Dictionary)props).put("service.description", "LogManager Configuration Admin support");
        this.loggingConfigurable = context.registerService(ManagedService.class.getName(), (Object)globalConfigurator, props);
        ManagedServiceFactory msf = new LogWriterManagedServiceFactory(this.logConfigManager);
        ((Dictionary)props).put("service.pid", FACTORY_PID_WRITERS);
        ((Dictionary)props).put("service.description", msf.getName());
        this.writerConfigurer = context.registerService(ManagedServiceFactory.class.getName(), (Object)msf, props);
        msf = new LoggerManagedServiceFactory(this.logConfigManager);
        ((Dictionary)props).put("service.pid", FACTORY_PID_CONFIGS);
        ((Dictionary)props).put("service.description", msf.getName());
        this.configConfigurer = context.registerService(ManagedServiceFactory.class.getName(), (Object)msf, props);
        try {
            SlingLogPanel.registerPanel(context);
        }
        catch (Throwable ignore) {
            // empty catch block
        }
    }

    void shutdown() {
        try {
            SlingLogPanel.unregisterPanel();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.loggingConfigurable != null) {
            this.loggingConfigurable.unregister();
            this.loggingConfigurable = null;
        }
        if (this.writerConfigurer != null) {
            this.writerConfigurer.unregister();
            this.writerConfigurer = null;
        }
        if (this.configConfigurer != null) {
            this.configConfigurer.unregister();
            this.configConfigurer = null;
        }
        this.logConfigManager.close();
    }

    private Dictionary<String, String> getBundleConfiguration(BundleContext bundleContext) {
        String[] props;
        Hashtable<String, String> config = new Hashtable<String, String>();
        for (String prop : props = new String[]{LOG_LEVEL, LOG_LEVEL, LOG_FILE, LOG_FILE_NUMBER, LOG_FILE_SIZE, LOG_PATTERN}) {
            String value = bundleContext.getProperty(prop);
            if (value == null) continue;
            ((Dictionary)config).put(prop, value);
        }
        if (((Dictionary)config).get(LOG_LEVEL) == null) {
            ((Dictionary)config).put(LOG_LEVEL, LOG_LEVEL_DEFAULT);
        }
        return config;
    }

    private static class LoggerManagedServiceFactory
    implements ManagedServiceFactory {
        private final LogConfigManager logConfigManager;

        LoggerManagedServiceFactory(LogConfigManager logConfigManager) {
            this.logConfigManager = logConfigManager;
        }

        public String getName() {
            return "Logger configurator";
        }

        public void updated(String pid, Dictionary configuration) throws ConfigurationException {
            this.logConfigManager.updateLoggerConfiguration(pid, configuration);
        }

        public void deleted(String pid) {
            try {
                this.logConfigManager.updateLoggerConfiguration(pid, null);
            }
            catch (ConfigurationException ce) {
                LogConfigManager.internalFailure("Unexpected Configuration Problem", ce);
            }
        }
    }

    private static class LogWriterManagedServiceFactory
    implements ManagedServiceFactory {
        private final LogConfigManager logConfigManager;

        LogWriterManagedServiceFactory(LogConfigManager logConfigManager) {
            this.logConfigManager = logConfigManager;
        }

        public String getName() {
            return "LogWriter configurator";
        }

        public void updated(String pid, Dictionary configuration) throws ConfigurationException {
            this.logConfigManager.updateLogWriter(pid, configuration);
        }

        public void deleted(String pid) {
            try {
                this.logConfigManager.updateLogWriter(pid, null);
            }
            catch (ConfigurationException ce) {
                LogConfigManager.internalFailure("Unexpected Configuration Problem", ce);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GlobalConfigurator
    implements ManagedService {
        private final LogConfigManager logConfigManager;
        private final Dictionary<String, String> defaultConfiguration;

        GlobalConfigurator(LogConfigManager logConfigManager, Dictionary<String, String> defaultConfiguration) {
            this.logConfigManager = logConfigManager;
            this.defaultConfiguration = defaultConfiguration;
        }

        @Override
        public void updated(Dictionary properties) throws ConfigurationException {
            if (properties == null) {
                properties = this.defaultConfiguration;
            }
            properties.put(LogManager.LOG_LOGGERS, "");
            this.logConfigManager.updateLogWriter(LogManager.PID, properties);
            this.logConfigManager.updateLoggerConfiguration(LogManager.PID, properties);
        }
    }
}

