/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.internal.slf4j;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.sling.commons.log.internal.slf4j.SlingLoggerConfig;
import org.apache.sling.commons.log.internal.slf4j.SlingLoggerLevel;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

class SlingLogger
implements LocationAwareLogger {
    private final String name;
    private SlingLoggerConfig config;

    SlingLogger(String name) {
        this.name = name;
    }

    void setLoggerConfig(SlingLoggerConfig config) {
        this.config = config;
    }

    private void log(Marker marker, SlingLoggerLevel level, String msg, Throwable t) {
        this.log(marker, null, level, msg, t);
    }

    private void log(Marker marker, String fqcn, SlingLoggerLevel level, String msg, Throwable t) {
        StringWriter writer = new StringWriter();
        this.config.formatMessage(writer.getBuffer(), marker, this.getName(), level, msg, fqcn);
        boolean needsEOL = true;
        if (t != null) {
            writer.write(32);
            PrintWriter pw = new PrintWriter(writer);
            t.printStackTrace(pw);
            pw.flush();
            needsEOL = false;
        }
        this.config.printMessage(writer.toString(), needsEOL);
    }

    public String getName() {
        return this.name;
    }

    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.log(null, SlingLoggerLevel.TRACE, msg, null);
        }
    }

    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            this.log(null, SlingLoggerLevel.TRACE, MessageFormatter.format(format, arg), null);
        }
    }

    public void trace(String format, Object[] argArray) {
        if (this.isTraceEnabled()) {
            this.log(null, SlingLoggerLevel.TRACE, MessageFormatter.arrayFormat(format, argArray), null);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            this.log(null, SlingLoggerLevel.TRACE, msg, t);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.log(null, SlingLoggerLevel.TRACE, MessageFormatter.format(format, arg1, arg2), null);
        }
    }

    public void trace(Marker marker, String msg) {
        if (this.isTraceEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.TRACE, msg, null);
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        if (this.isTraceEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.TRACE, MessageFormatter.format(format, arg), null);
        }
    }

    public void trace(Marker marker, String format, Object[] argArray) {
        if (this.isTraceEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.TRACE, MessageFormatter.arrayFormat(format, argArray), null);
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        if (this.isTraceEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.TRACE, msg, t);
        }
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.TRACE, MessageFormatter.format(format, arg1, arg2), null);
        }
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.log(null, SlingLoggerLevel.DEBUG, msg, null);
        }
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.log(null, SlingLoggerLevel.DEBUG, MessageFormatter.format(format, arg), null);
        }
    }

    public void debug(String format, Object[] argArray) {
        if (this.isDebugEnabled()) {
            this.log(null, SlingLoggerLevel.DEBUG, MessageFormatter.arrayFormat(format, argArray), null);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.log(null, SlingLoggerLevel.DEBUG, msg, t);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.log(null, SlingLoggerLevel.DEBUG, MessageFormatter.format(format, arg1, arg2), null);
        }
    }

    public void debug(Marker marker, String msg) {
        if (this.isDebugEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.DEBUG, msg, null);
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.isDebugEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.DEBUG, MessageFormatter.format(format, arg), null);
        }
    }

    public void debug(Marker marker, String format, Object[] argArray) {
        if (this.isDebugEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.DEBUG, MessageFormatter.arrayFormat(format, argArray), null);
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.isDebugEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.DEBUG, msg, t);
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.DEBUG, MessageFormatter.format(format, arg1, arg2), null);
        }
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.log(null, SlingLoggerLevel.INFO, msg, null);
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.log(null, SlingLoggerLevel.INFO, MessageFormatter.format(format, arg), null);
        }
    }

    public void info(String format, Object[] argArray) {
        if (this.isInfoEnabled()) {
            this.log(null, SlingLoggerLevel.INFO, MessageFormatter.arrayFormat(format, argArray), null);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.log(null, SlingLoggerLevel.INFO, msg, t);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.log(null, SlingLoggerLevel.INFO, MessageFormatter.format(format, arg1, arg2), null);
        }
    }

    public void info(Marker marker, String msg) {
        if (this.isInfoEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.INFO, msg, null);
        }
    }

    public void info(Marker marker, String format, Object arg) {
        if (this.isInfoEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.INFO, MessageFormatter.format(format, arg), null);
        }
    }

    public void info(Marker marker, String format, Object[] argArray) {
        if (this.isInfoEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.INFO, MessageFormatter.arrayFormat(format, argArray), null);
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.isInfoEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.INFO, msg, t);
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.INFO, MessageFormatter.format(format, arg1, arg2), null);
        }
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.log(null, SlingLoggerLevel.WARN, msg, null);
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.log(null, SlingLoggerLevel.WARN, MessageFormatter.format(format, arg), null);
        }
    }

    public void warn(String format, Object[] argArray) {
        if (this.isWarnEnabled()) {
            this.log(null, SlingLoggerLevel.WARN, MessageFormatter.arrayFormat(format, argArray), null);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.log(null, SlingLoggerLevel.WARN, msg, t);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.log(null, SlingLoggerLevel.WARN, MessageFormatter.format(format, arg1, arg2), null);
        }
    }

    public void warn(Marker marker, String msg) {
        if (this.isWarnEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.WARN, msg, null);
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        if (this.isWarnEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.WARN, MessageFormatter.format(format, arg), null);
        }
    }

    public void warn(Marker marker, String format, Object[] argArray) {
        if (this.isWarnEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.WARN, MessageFormatter.arrayFormat(format, argArray), null);
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (this.isWarnEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.WARN, msg, t);
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.WARN, MessageFormatter.format(format, arg1, arg2), null);
        }
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.log(null, SlingLoggerLevel.ERROR, msg, null);
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.log(null, SlingLoggerLevel.ERROR, MessageFormatter.format(format, arg), null);
        }
    }

    public void error(String format, Object[] argArray) {
        if (this.isErrorEnabled()) {
            this.log(null, SlingLoggerLevel.ERROR, MessageFormatter.arrayFormat(format, argArray), null);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.log(null, SlingLoggerLevel.ERROR, msg, t);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.log(null, SlingLoggerLevel.ERROR, MessageFormatter.format(format, arg1, arg2), null);
        }
    }

    public void error(Marker marker, String msg) {
        if (this.isErrorEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.ERROR, msg, null);
        }
    }

    public void error(Marker marker, String format, Object arg) {
        if (this.isErrorEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.ERROR, MessageFormatter.format(format, arg), null);
        }
    }

    public void error(Marker marker, String format, Object[] argArray) {
        if (this.isErrorEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.ERROR, MessageFormatter.arrayFormat(format, argArray), null);
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (this.isErrorEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.ERROR, msg, t);
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled(marker)) {
            this.log(marker, SlingLoggerLevel.ERROR, MessageFormatter.format(format, arg1, arg2), null);
        }
    }

    public boolean isTraceEnabled() {
        return this.config.isLevel(SlingLoggerLevel.TRACE);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.config.isLevel(SlingLoggerLevel.TRACE);
    }

    public boolean isDebugEnabled() {
        return this.config.isLevel(SlingLoggerLevel.DEBUG);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.config.isLevel(SlingLoggerLevel.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.config.isLevel(SlingLoggerLevel.INFO);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.config.isLevel(SlingLoggerLevel.INFO);
    }

    public boolean isWarnEnabled() {
        return this.config.isLevel(SlingLoggerLevel.WARN);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.config.isLevel(SlingLoggerLevel.WARN);
    }

    public boolean isErrorEnabled() {
        return this.config.isLevel(SlingLoggerLevel.ERROR);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.config.isLevel(SlingLoggerLevel.ERROR);
    }

    public void log(Marker marker, String fqcn, int level, String message, Throwable t) {
        SlingLoggerLevel slingLevel = SlingLoggerLevel.fromSlf4jLevel(level);
        if (this.config.isLevel(slingLevel)) {
            this.log(marker, fqcn, slingLevel, message, t);
        }
    }
}

