/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.internal.slf4j;

import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.commons.log.internal.config.ConfigurationException;
import org.apache.sling.commons.log.internal.slf4j.SlingLogger;
import org.apache.sling.commons.log.internal.slf4j.SlingLoggerConfig;
import org.apache.sling.commons.log.internal.slf4j.SlingLoggerLevel;
import org.apache.sling.commons.log.internal.slf4j.SlingLoggerWriter;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogConfigManager
implements ILoggerFactory {
    public static final String ROOT = "";
    private static LogConfigManager instance = new LogConfigManager();
    private final Map<String, SlingLoggerWriter> writerByPid = new ConcurrentHashMap<String, SlingLoggerWriter>();
    private final Map<String, SlingLoggerWriter> writerByFileName = new ConcurrentHashMap<String, SlingLoggerWriter>();
    private final Map<String, SlingLoggerConfig> configByPid = new ConcurrentHashMap<String, SlingLoggerConfig>();
    private final Map<String, SlingLoggerConfig> configByCategory = new ConcurrentHashMap<String, SlingLoggerConfig>();
    private final Map<String, SoftReference<SlingLogger>> loggersByCategory = new ConcurrentHashMap<String, SoftReference<SlingLogger>>();
    private final SlingLoggerConfig defaultLoggerConfig;
    private final SlingLoggerWriter defaultWriter = new SlingLoggerWriter("org.apache.sling.commons.log.LogManager");
    private File rootDir;
    private Dictionary<String, String> defaultConfiguration;

    public static LogConfigManager getInstance() {
        return instance;
    }

    public static void internalFailure(String message, Throwable t) {
        System.err.println(message);
        if (t != null) {
            t.printStackTrace(System.err);
        }
    }

    private LogConfigManager() {
        try {
            this.defaultWriter.configure(null, 0, "0");
        }
        catch (IOException ioe) {
            LogConfigManager.internalFailure("Cannot initialize default SlingLoggerWriter", ioe);
        }
        this.writerByPid.put("org.apache.sling.commons.log.LogManager", this.defaultWriter);
        HashSet<String> defaultCategories = new HashSet<String>();
        defaultCategories.add(ROOT);
        this.defaultLoggerConfig = new SlingLoggerConfig("org.apache.sling.commons.log.LogManager", "{0,date,dd.MM.yyyy HH:mm:ss.SSS} *{4}* [{2}] {3} {5}", defaultCategories, SlingLoggerLevel.INFO, this.defaultWriter);
        this.configByPid.put("org.apache.sling.commons.log.LogManager", this.defaultLoggerConfig);
        this.configByCategory.put(ROOT, this.defaultLoggerConfig);
    }

    public void setRoot(String root) {
        this.rootDir = new File(root == null ? ROOT : root).getAbsoluteFile();
    }

    public void setDefaultConfiguration(Dictionary<String, String> defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
        try {
            this.updateGlobalConfiguration(defaultConfiguration);
        }
        catch (ConfigurationException ce) {
            LogConfigManager.internalFailure(ce.getMessage(), ce);
        }
    }

    public void close() {
        this.writerByPid.clear();
        this.writerByFileName.clear();
        this.configByPid.clear();
        this.configByCategory.clear();
        for (SoftReference<SlingLogger> logger : this.loggersByCategory.values()) {
            logger.clear();
        }
        this.loggersByCategory.clear();
        try {
            this.defaultWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Logger getLogger(String name) {
        SlingLogger slingLogger;
        SoftReference<SlingLogger> logger = this.loggersByCategory.get(name);
        SlingLogger slingLogger2 = slingLogger = logger != null ? logger.get() : null;
        if (slingLogger == null) {
            slingLogger = new SlingLogger(name);
            slingLogger.setLoggerConfig(this.getLoggerConfig(name));
            this.loggersByCategory.put(name, new SoftReference<SlingLogger>(slingLogger));
        }
        return slingLogger;
    }

    Iterator<SlingLoggerConfig> getSlingLoggerConfigs() {
        return this.configByPid.values().iterator();
    }

    Iterator<SlingLoggerWriter> getSlingLoggerWriters() {
        return this.internalGetSlingLoggerWriters().iterator();
    }

    int getNumSlingLoggerConfigs() {
        return this.configByPid.size();
    }

    int getNumSlingLogWriters() {
        return this.internalGetSlingLoggerWriters().size();
    }

    int getNumLoggers() {
        return this.loggersByCategory.size();
    }

    private Collection<SlingLoggerWriter> internalGetSlingLoggerWriters() {
        HashSet<SlingLoggerWriter> writers = new HashSet<SlingLoggerWriter>(this.writerByPid.values());
        for (SlingLoggerWriter slw : this.writerByFileName.values()) {
            if (slw.getConfigurationPID() != null) continue;
            writers.add(slw);
        }
        return writers;
    }

    public void updateGlobalConfiguration(Dictionary<String, String> configuration) throws ConfigurationException {
        if (configuration == null) {
            configuration = this.defaultConfiguration;
        }
        configuration.put("org.apache.sling.commons.log.names", ROOT);
        this.updateLogWriter("org.apache.sling.commons.log.LogManager", configuration);
        this.updateLoggerConfiguration("org.apache.sling.commons.log.LogManager", configuration);
    }

    public void updateLogWriter(String pid, Dictionary<?, ?> configuration) throws ConfigurationException {
        if (configuration != null) {
            SlingLoggerWriter existingWriter;
            SlingLoggerWriter slw = this.writerByPid.get(pid);
            String logFileName = (String)configuration.get("org.apache.sling.commons.log.file");
            if (logFileName != null && logFileName.trim().length() == 0) {
                logFileName = null;
            }
            if (logFileName != null && (existingWriter = this.writerByFileName.get(logFileName = this.getAbsoluteLogFile(logFileName))) != null) {
                if (slw == null) {
                    slw = existingWriter;
                    slw.setConfigurationPID(pid);
                    this.writerByPid.put(pid, slw);
                } else if (!existingWriter.getConfigurationPID().equals(pid)) {
                    throw new ConfigurationException("org.apache.sling.commons.log.file", "LogFile " + logFileName + " already configured by configuration " + existingWriter.getConfigurationPID());
                }
            }
            Object fileNumProp = configuration.get("org.apache.sling.commons.log.file.number");
            int fileNum = -1;
            if (fileNumProp instanceof Number) {
                fileNum = ((Number)fileNumProp).intValue();
            } else if (fileNumProp != null) {
                try {
                    fileNum = Integer.parseInt(fileNumProp.toString());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            Object fileSizeProp = configuration.get("org.apache.sling.commons.log.file.size");
            String fileSize = null;
            if (fileSizeProp != null) {
                fileSize = fileSizeProp.toString();
            }
            if (this.configureLogWriter(slw, pid, logFileName, fileNum, fileSize) == null) {
                throw new ConfigurationException("org.apache.sling.commons.log.file", "Cannot create writer for log file " + logFileName);
            }
        } else {
            SlingLoggerWriter logWriter = this.writerByPid.remove(pid);
            if (logWriter != null) {
                logWriter.setConfigurationPID(null);
                this.closeIfUnused(logWriter, true);
            }
        }
    }

    public void updateLoggerConfiguration(String pid, Dictionary<?, ?> configuration) throws ConfigurationException {
        boolean reconfigureLoggers = true;
        if (configuration != null) {
            SlingLoggerConfig config;
            SlingLoggerWriter writer;
            String pattern = (String)configuration.get("org.apache.sling.commons.log.pattern");
            String level = (String)configuration.get("org.apache.sling.commons.log.level");
            String file = (String)configuration.get("org.apache.sling.commons.log.file");
            Set<String> categories = this.toCategoryList(configuration.get("org.apache.sling.commons.log.names"));
            if (categories == null) {
                throw new ConfigurationException("org.apache.sling.commons.log.names", "Missing categories in configuration " + pid);
            }
            for (String cat : categories) {
                SlingLoggerConfig cfg = this.configByCategory.get(cat);
                if (cfg == null || pid.equals(cfg.getConfigPid())) continue;
                throw new ConfigurationException("org.apache.sling.commons.log.names", "Category " + cat + " already defined by configuration " + pid);
            }
            if (file != null && file.length() > 0) {
                writer = this.writerByPid.get(file);
                if (writer == null && (writer = this.writerByFileName.get(file)) == null && (writer = this.writerByFileName.get(file = this.getAbsoluteLogFile(file))) == null) {
                    writer = this.configureLogWriter(null, null, file, -1, null);
                }
            } else {
                writer = this.defaultWriter;
            }
            if (level == null) {
                throw new ConfigurationException("org.apache.sling.commons.log.level", "Value required");
            }
            SlingLoggerLevel logLevel = SlingLoggerLevel.valueOf(level.toUpperCase());
            if (pattern == null || pattern.length() == 0) {
                pattern = "{0,date,dd.MM.yyyy HH:mm:ss.SSS} *{4}* [{2}] {3} {5}";
            }
            if ((config = this.configByPid.get(pid)) == null) {
                config = new SlingLoggerConfig(pid, pattern, categories, logLevel, writer);
                this.configByPid.put(pid, config);
            } else {
                Set<String> oldCategories = config.getCategories();
                SlingLoggerWriter oldWriter = config.getLogWriter();
                config.configure(pattern, categories, logLevel, writer);
                if (((Object)categories).equals(oldCategories)) {
                    categories.clear();
                    reconfigureLoggers = false;
                } else {
                    this.configByCategory.keySet().removeAll(oldCategories);
                }
                if (oldWriter != writer) {
                    this.closeIfUnused(oldWriter, false);
                }
            }
            for (String cat : categories) {
                this.configByCategory.put(cat, config);
            }
        } else {
            SlingLoggerConfig config = this.configByPid.remove(pid);
            if (config != null) {
                this.configByCategory.keySet().removeAll(config.getCategories());
                this.closeIfUnused(config.getLogWriter(), false);
            }
        }
        if (reconfigureLoggers) {
            this.reconfigureLoggers();
        }
    }

    private String getAbsoluteLogFile(String logFileName) {
        File logFile = new File(logFileName = logFileName.replace('/', File.separatorChar));
        if (!logFile.isAbsolute()) {
            logFile = new File(this.rootDir, logFileName);
            logFileName = logFile.getAbsolutePath();
        }
        return logFileName;
    }

    private void reconfigureLoggers() {
        Iterator<SoftReference<SlingLogger>> si = this.loggersByCategory.values().iterator();
        while (si.hasNext()) {
            SlingLogger logger = si.next().get();
            if (logger != null) {
                logger.setLoggerConfig(this.getLoggerConfig(logger.getName()));
                continue;
            }
            si.remove();
        }
    }

    private SlingLoggerConfig getLoggerConfig(String logger) {
        while (true) {
            SlingLoggerConfig config;
            if ((config = this.configByCategory.get(logger)) != null) {
                return config;
            }
            if (logger.length() == 0) break;
            int dot = logger.lastIndexOf(46);
            if (dot < 0) {
                logger = ROOT;
                continue;
            }
            logger = logger.substring(0, dot);
        }
        return this.defaultLoggerConfig;
    }

    private Set<String> toCategoryList(Object loggers) {
        if (loggers == null) {
            return null;
        }
        HashSet<String> loggerNames = new HashSet<String>();
        if (loggers == ROOT) {
            loggerNames.add(ROOT);
            return loggerNames;
        }
        Object[] loggersArray = loggers.getClass().isArray() ? (Object[])loggers : (loggers instanceof Collection ? ((Collection)loggers).toArray() : new Object[]{loggers});
        for (Object loggerObject : loggersArray) {
            String[] splitLoggers;
            if (loggerObject == null) continue;
            for (String logger : splitLoggers = loggerObject.toString().split(",")) {
                if ((logger = logger.trim()).length() <= 0) continue;
                loggerNames.add(logger);
            }
        }
        return loggerNames;
    }

    private SlingLoggerWriter configureLogWriter(SlingLoggerWriter writer, String pid, String fileName, int fileNum, String threshold) {
        if (writer == null) {
            writer = new SlingLoggerWriter(pid);
        } else {
            writer.setConfigurationPID(pid);
        }
        if (fileNum < 0) {
            fileNum = 5;
        }
        if (threshold == null || threshold.length() == 0) {
            threshold = "'.'yyyy-MM-dd";
        }
        try {
            writer.configure(fileName, fileNum, threshold);
        }
        catch (IOException ioe) {
            LogConfigManager.internalFailure("Cannot create log file " + fileName, ioe);
            LogConfigManager.internalFailure("Logging to the console", null);
            return null;
        }
        if (pid != null) {
            this.writerByPid.put(pid, writer);
        }
        if (fileName != null) {
            this.writerByFileName.put(fileName, writer);
        }
        return writer;
    }

    private void closeIfUnused(SlingLoggerWriter logWriter, boolean reset) {
        if (logWriter.getConfigurationPID() != null) {
            return;
        }
        for (SlingLoggerConfig config : this.configByPid.values()) {
            if (config.getLogWriter() != logWriter) continue;
            if (reset) {
                try {
                    logWriter.configure(logWriter.getPath(), 5, "'.'yyyy-MM-dd");
                }
                catch (IOException ioe) {
                    LogConfigManager.internalFailure("Cannot reset the log writer to default configuration", ioe);
                }
            }
            return;
        }
        String path = logWriter.getPath();
        if (path != null) {
            this.writerByFileName.remove(path);
        }
        try {
            logWriter.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }
}

