/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.internal;

import org.apache.sling.commons.log.internal.LogManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Activator
implements BundleActivator {
    private static final String JUL_SUPPORT = "org.apache.sling.commons.log.julenabled";
    private LogManager logManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        this.logManager = new LogManager(context);
        if (Boolean.parseBoolean(context.getProperty(JUL_SUPPORT))) {
            if (System.getProperty("java.util.logging.config.file") == null && System.getProperty("java.util.logging.config.class") == null) {
                Thread ct = Thread.currentThread();
                ClassLoader old = ct.getContextClassLoader();
                try {
                    ct.setContextClassLoader(this.getClass().getClassLoader());
                    System.setProperty("java.util.logging.config.class", "org.apache.sling.commons.log.internal.Activator.DummyLogManagerConfiguration");
                    java.util.logging.LogManager.getLogManager().reset();
                }
                finally {
                    ct.setContextClassLoader(old);
                    System.clearProperty("java.util.logging.config.class");
                }
            }
            SLF4JBridgeHandler.install();
        }
    }

    public void stop(BundleContext context) throws Exception {
        SLF4JBridgeHandler.uninstall();
        if (this.logManager != null) {
            this.logManager.shutdown();
            this.logManager = null;
        }
    }

    public static class DummyLogManagerConfiguration {
    }
}

