/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.commons.log.internal.config.ConfigurationServiceFactory;
import org.apache.sling.commons.log.internal.slf4j.LogConfigManager;
import org.apache.sling.commons.log.internal.slf4j.SlingConfigurationPrinter;
import org.apache.sling.commons.log.internal.slf4j.SlingLogPanel;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogManager {
    public static final String LOG_LEVEL = "org.apache.sling.commons.log.level";
    public static final String LOG_FILE = "org.apache.sling.commons.log.file";
    public static final String LOG_FILE_NUMBER = "org.apache.sling.commons.log.file.number";
    public static final String LOG_FILE_SIZE = "org.apache.sling.commons.log.file.size";
    public static final String LOG_PATTERN = "org.apache.sling.commons.log.pattern";
    public static final String LOG_PATTERN_DEFAULT = "{0,date,dd.MM.yyyy HH:mm:ss.SSS} *{4}* [{2}] {3} {5}";
    public static final String LOG_LOGGERS = "org.apache.sling.commons.log.names";
    public static final String LOG_LEVEL_DEFAULT = "INFO";
    public static final int LOG_FILE_NUMBER_DEFAULT = 5;
    public static final String LOG_FILE_SIZE_DEFAULT = "'.'yyyy-MM-dd";
    public static final String PID = "org.apache.sling.commons.log.LogManager";
    public static final String FACTORY_PID_WRITERS = "org.apache.sling.commons.log.LogManager.factory.writer";
    public static final String FACTORY_PID_CONFIGS = "org.apache.sling.commons.log.LogManager.factory.config";
    private final LogConfigManager logConfigManager = LogConfigManager.getInstance();
    private Logger log;
    private ServiceRegistration loggingConfigurable;
    private ServiceRegistration writerConfigurer;
    private ServiceRegistration configConfigurer;
    private ServiceRegistration panelRegistration;

    LogManager(BundleContext context) {
        this.logConfigManager.setRoot(context.getProperty("sling.home"));
        this.logConfigManager.setDefaultConfiguration(this.getBundleConfiguration(context));
        this.log = LoggerFactory.getLogger(LogManager.class);
        this.log.info("LogManager: Logging set up from context");
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("service.pid", PID);
        ((Dictionary)props).put("service.description", "LogManager Configuration Admin support");
        this.loggingConfigurable = context.registerService("org.osgi.service.cm.ManagedService", (Object)new ConfigurationServiceFactory(this.logConfigManager, "org.apache.sling.commons.log.internal.config.GlobalConfigurator"), props);
        ConfigurationServiceFactory msf = new ConfigurationServiceFactory(this.logConfigManager, "org.apache.sling.commons.log.internal.config.LogWriterManagedServiceFactory");
        ((Dictionary)props).put("service.pid", FACTORY_PID_WRITERS);
        ((Dictionary)props).put("service.description", "LogWriter configurator");
        this.writerConfigurer = context.registerService("org.osgi.service.cm.ManagedServiceFactory", (Object)msf, props);
        msf = new ConfigurationServiceFactory(this.logConfigManager, "org.apache.sling.commons.log.internal.config.LoggerManagedServiceFactory");
        ((Dictionary)props).put("service.pid", FACTORY_PID_CONFIGS);
        ((Dictionary)props).put("service.description", "Logger configurator");
        this.configConfigurer = context.registerService("org.osgi.service.cm.ManagedServiceFactory", (Object)msf, props);
        try {
            this.registerPanel(context);
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        SlingConfigurationPrinter.registerPrinter(context);
    }

    void shutdown() {
        this.unregisterPanel();
        SlingConfigurationPrinter.unregisterPrinter();
        if (this.loggingConfigurable != null) {
            this.loggingConfigurable.unregister();
            this.loggingConfigurable = null;
        }
        if (this.writerConfigurer != null) {
            this.writerConfigurer.unregister();
            this.writerConfigurer = null;
        }
        if (this.configConfigurer != null) {
            this.configConfigurer.unregister();
            this.configConfigurer = null;
        }
        this.logConfigManager.close();
    }

    private Dictionary<String, String> getBundleConfiguration(BundleContext bundleContext) {
        String[] props;
        Hashtable<String, String> config = new Hashtable<String, String>();
        for (String prop : props = new String[]{LOG_LEVEL, LOG_LEVEL, LOG_FILE, LOG_FILE_NUMBER, LOG_FILE_SIZE, LOG_PATTERN}) {
            String value = bundleContext.getProperty(prop);
            if (value == null) continue;
            ((Dictionary)config).put(prop, value);
        }
        if (((Dictionary)config).get(LOG_LEVEL) == null) {
            ((Dictionary)config).put(LOG_LEVEL, LOG_LEVEL_DEFAULT);
        }
        return config;
    }

    private void registerPanel(BundleContext ctx) {
        if (this.panelRegistration == null) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("felix.webconsole.label", "slinglog");
            ((Dictionary)props).put("felix.webconsole.title", "Sling Log Support");
            ((Dictionary)props).put("sling.core.servletName", "Sling Log Support Console Servlet");
            this.panelRegistration = ctx.registerService("javax.servlet.Servlet", (Object)new ServiceFactory(){
                private Object instance;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object getService(Bundle bundle, ServiceRegistration registration) {
                    1 var3_3 = this;
                    synchronized (var3_3) {
                        if (this.instance == null) {
                            this.instance = new SlingLogPanel(LogManager.this.logConfigManager);
                        }
                        return this.instance;
                    }
                }

                public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
                }
            }, props);
        }
    }

    private void unregisterPanel() {
        if (this.panelRegistration != null) {
            this.panelRegistration.unregister();
            this.panelRegistration = null;
        }
    }
}

