/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.internal.slf4j;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.sling.commons.log.internal.slf4j.LogConfigManager;
import org.apache.sling.commons.log.internal.slf4j.SlingLoggerWriter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class SlingConfigurationPrinter {
    private static ServiceRegistration registration;

    public static void registerPrinter(BundleContext ctx) {
        if (registration == null) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("felix.webconsole.label", "slinglogs");
            ((Dictionary)props).put("felix.webconsole.title", "Log Files");
            ((Dictionary)props).put("felix.webconsole.configprinter.modes", "always");
            SlingConfigurationPrinter printer = new SlingConfigurationPrinter();
            registration = ctx.registerService(SlingConfigurationPrinter.class.getName(), (Object)printer, props);
        }
    }

    public static void unregisterPrinter() {
        if (registration != null) {
            registration.unregister();
            registration = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printConfiguration(PrintWriter printWriter) {
        LogConfigManager logConfigManager = LogConfigManager.getInstance();
        Iterator<SlingLoggerWriter> writers = logConfigManager.getSlingLoggerWriters();
        while (writers.hasNext()) {
            SlingLoggerWriter writer = writers.next();
            File file = writer.getFile();
            if (file == null) continue;
            printWriter.print("Log file ");
            printWriter.println(SlingConfigurationPrinter.getPath(writer));
            printWriter.println("--------------------------------------------------");
            FileReader fr = null;
            try {
                int len;
                fr = new FileReader(file);
                char[] buffer = new char[512];
                while ((len = fr.read(buffer)) != -1) {
                    printWriter.write(buffer, 0, len);
                }
            }
            catch (IOException ignore) {
            }
            finally {
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException ignoreCloseException) {}
                }
            }
            printWriter.println();
        }
    }

    public URL[] getAttachments(String mode) {
        if ("zip".equals(mode)) {
            ArrayList<URL> urls = new ArrayList<URL>();
            LogConfigManager logConfigManager = LogConfigManager.getInstance();
            Iterator<SlingLoggerWriter> writers = logConfigManager.getSlingLoggerWriters();
            while (writers.hasNext()) {
                SlingLoggerWriter writer = writers.next();
                File[] files = writer.getFileRotator().getRotatedFiles(writer.getFile());
                if (files == null) continue;
                for (int i = 0; i < files.length; ++i) {
                    try {
                        urls.add(files[i].toURL());
                        continue;
                    }
                    catch (MalformedURLException mue) {
                        // empty catch block
                    }
                }
            }
            if (urls.size() > 0) {
                return urls.toArray(new URL[urls.size()]);
            }
        }
        return null;
    }

    private static String getPath(SlingLoggerWriter writer) {
        String path = writer.getPath();
        return path != null ? path : "[stdout]";
    }
}

