/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.internal.slf4j;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.commons.log.internal.slf4j.LogConfigManager;
import org.apache.sling.commons.log.internal.slf4j.SlingLoggerConfig;
import org.apache.sling.commons.log.internal.slf4j.SlingLoggerWriter;

public class SlingLogPanel
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final LogConfigManager logConfigManager;

    public SlingLogPanel(LogConfigManager logConfigManager) {
        this.logConfigManager = logConfigManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        PrintWriter pw = resp.getWriter();
        LogConfigManager logConfigManager = this.logConfigManager;
        String consoleAppRoot = (String)req.getAttribute("felix.webconsole.appRoot");
        String cfgColTitle = consoleAppRoot == null ? "PID" : "Configuration";
        pw.printf("<p class='statline'>Log Service Stats: %d categories, %d configuration(s), %d writer(s)</p>%n", logConfigManager.getNumLoggers(), logConfigManager.getNumSlingLoggerConfigs(), logConfigManager.getNumSlingLogWriters());
        pw.println("<div class='table'>");
        pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>Logger</div>");
        pw.println("<table class='nicetable ui-widget'>");
        pw.println("<thead class='ui-widget-header'>");
        pw.println("<tr>");
        pw.println("<th>Log Level</th>");
        pw.println("<th>Log File</th>");
        pw.println("<th>Logger</th>");
        pw.println("<th>" + cfgColTitle + "</th>");
        pw.println("</tr>");
        pw.println("</thead>");
        pw.println("<tbody class='ui-widget-content'>");
        Iterator<SlingLoggerConfig> loggers = logConfigManager.getSlingLoggerConfigs();
        while (loggers.hasNext()) {
            SlingLoggerConfig logger = loggers.next();
            pw.println("<tr>");
            pw.println("<td>" + (Object)((Object)logger.getLogLevel()) + "</td>");
            pw.println("<td>" + SlingLogPanel.getPath(logger.getLogWriter()) + "</td>");
            pw.println("<td>");
            String sep = "";
            for (String cat : logger.getCategories()) {
                pw.print(sep);
                pw.println(cat);
                sep = "<br />";
            }
            pw.println("</td>");
            pw.println("<td>" + SlingLogPanel.formatPid(consoleAppRoot, logger.getConfigPid()) + "</td>");
            pw.println("</tr>");
        }
        pw.println("</tbody>");
        pw.println("</table>");
        pw.println("</div>");
        pw.println("<div class='table'>");
        pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>Log Writer</div>");
        pw.println("<table class='nicetable ui-widget'>");
        pw.println("<thead class='ui-widget-header'>");
        pw.println("<tr>");
        pw.println("<th>Log File</th>");
        pw.println("<th>Rotator</th>");
        pw.println("<th>" + cfgColTitle + "</th>");
        pw.println("</tr>");
        pw.println("</thead>");
        pw.println("<tbody class='ui-widget-content'>");
        Iterator<SlingLoggerWriter> writers = logConfigManager.getSlingLoggerWriters();
        while (writers.hasNext()) {
            SlingLoggerWriter writer = writers.next();
            pw.println("<tr>");
            pw.println("<td>" + SlingLogPanel.getPath(writer) + "</td>");
            pw.println("<td>" + writer.getFileRotator() + "</td>");
            pw.println("<td>" + SlingLogPanel.formatPid(consoleAppRoot, writer.getConfigurationPID()) + "</td>");
            pw.println("</tr>");
        }
        pw.println("</tbody>");
        pw.println("</table>");
        pw.println("</div>");
    }

    private static String getPath(SlingLoggerWriter writer) {
        String path = writer.getPath();
        return path != null ? path : "[stdout]";
    }

    private static String formatPid(String consoleAppRoot, String pid) {
        if (pid == null) {
            return "[implicit]";
        }
        if (consoleAppRoot == null) {
            return "<a href=\"configMgr/" + pid + "\">" + pid + "</a>";
        }
        return "<a href=\"configMgr/" + pid + "\"><img src=\"" + consoleAppRoot + "/res/imgs/component_configure.png\" border=\"0\" /></a>";
    }
}

