/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal.util;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.sling.commons.log.logback.internal.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class XmlUtil {
    private static Logger log = LoggerFactory.getLogger(XmlUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prettyPrint(InputSource is) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StreamResult result = new StreamResult(new StringWriter());
            SAXSource source = new SAXSource(is);
            transformer.transform(source, result);
            String string = result.getWriter().toString();
            return string;
        }
        catch (Exception e) {
            log.warn("Error occurred while transforming xml", (Throwable)e);
        }
        finally {
            Util.close(is);
        }
        return "Source not found";
    }

    public static String escapeXml(String xml) {
        return xml.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\\$", "&#37;");
    }
}

