/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.sling.commons.log.logback.internal.LogbackManager;
import org.apache.sling.commons.log.logback.internal.SlingLogPanel;

public class SlingConfigurationPrinter {
    private static final CachingDateFormatter SDF = new CachingDateFormatter("yyyy-MM-dd HH:mm:ss");
    private final LogbackManager logbackManager;

    public SlingConfigurationPrinter(LogbackManager logbackManager) {
        this.logbackManager = logbackManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printConfiguration(PrintWriter printWriter) {
        LogbackManager.LoggerStateContext ctx = this.logbackManager.determineLoggerState();
        SlingConfigurationPrinter.dumpLogbackStatus(this.logbackManager, printWriter);
        for (Appender<ILoggingEvent> appender : ctx.getAllAppenders()) {
            File file;
            if (!(appender instanceof FileAppender) || !(file = new File(((FileAppender)appender).getFile())).exists()) continue;
            printWriter.print("Log file ");
            printWriter.println(file.getAbsolutePath());
            printWriter.println("--------------------------------------------------");
            FileReader fr = null;
            try {
                int len;
                fr = new FileReader(file);
                char[] buffer = new char[512];
                while ((len = fr.read(buffer)) != -1) {
                    printWriter.write(buffer, 0, len);
                }
            }
            catch (IOException ignore) {
            }
            finally {
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            printWriter.println();
        }
    }

    public URL[] getAttachments(String mode) {
        if ("zip".equals(mode)) {
            ArrayList<URL> urls = new ArrayList<URL>();
            LogbackManager.LoggerStateContext ctx = this.logbackManager.determineLoggerState();
            for (Appender<ILoggingEvent> appender : ctx.getAllAppenders()) {
                File[] files;
                if (!(appender instanceof FileAppender)) continue;
                for (File f : files = SlingConfigurationPrinter.getRotatedFiles((FileAppender)appender)) {
                    try {
                        urls.add(f.toURI().toURL());
                    }
                    catch (MalformedURLException mue) {
                        // empty catch block
                    }
                }
            }
            if (urls.size() > 0) {
                return urls.toArray(new URL[urls.size()]);
            }
        }
        return null;
    }

    private static File[] getRotatedFiles(FileAppender app) {
        File file = new File(app.getFile());
        if (app instanceof RollingFileAppender) {
            File dir = file.getParentFile();
            final String baseName = file.getName();
            return dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(baseName);
                }
            });
        }
        return new File[]{file};
    }

    private static void dumpLogbackStatus(LogbackManager logbackManager, PrintWriter pw) {
        List statusList = logbackManager.getStatusManager().getCopyOfStatusList();
        pw.println("Logback Status");
        pw.println("--------------------------------------------------");
        for (Status s : statusList) {
            pw.printf("%s *%s* %s - %s %n", SDF.format(s.getDate().longValue()), SlingConfigurationPrinter.statusLevelAsString(s), SlingLogPanel.abbreviatedOrigin(s), s.getMessage());
            if (s.getThrowable() == null) continue;
            s.getThrowable().printStackTrace(pw);
        }
        pw.println();
    }

    private static String statusLevelAsString(Status s) {
        switch (s.getEffectiveLevel()) {
            case 0: {
                return "INFO";
            }
            case 1: {
                return "WARN";
            }
            case 2: {
                return "ERROR";
            }
        }
        return null;
    }
}

