/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.commons.log.logback.internal.LogbackResetListener;
import org.apache.sling.commons.log.logback.internal.OsgiAppenderRefInternalAction;
import org.apache.sling.commons.log.logback.internal.util.Util;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class AppenderTracker
extends ServiceTracker
implements LogbackResetListener {
    private static final String PROP_LOGGER = "loggers";
    private final LoggerContext loggerContext;
    private final Map<ServiceReference, AppenderInfo> appenders = new ConcurrentHashMap<ServiceReference, AppenderInfo>();
    private final Map<String, Set<String>> appenderNameToLoggerMap = new ConcurrentHashMap<String, Set<String>>();

    public AppenderTracker(BundleContext context, LoggerContext loggerContext) throws InvalidSyntaxException {
        super(context, AppenderTracker.createFilter(), null);
        this.loggerContext = loggerContext;
        super.open();
    }

    public Object addingService(ServiceReference reference) {
        Appender appender = (Appender)super.addingService(reference);
        appender.setContext((Context)this.loggerContext);
        appender.start();
        AppenderInfo ai = new AppenderInfo(reference, (Appender<ILoggingEvent>)appender);
        this.appenders.put(reference, ai);
        this.attachAppender(ai);
        return appender;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.detachAppender(this.appenders.remove(reference));
        AppenderInfo nai = new AppenderInfo(reference, (Appender<ILoggingEvent>)((Appender)service));
        this.appenders.put(reference, nai);
        this.attachAppender(nai);
    }

    public void removedService(ServiceReference reference, Object service) {
        AppenderInfo ai = this.appenders.remove(reference);
        this.detachAppender(ai);
        if (ai != null) {
            ai.appender.stop();
        }
        super.removedService(reference, service);
    }

    public Collection<AppenderInfo> getAppenderInfos() {
        return this.appenders.values();
    }

    private void detachAppender(AppenderInfo ai) {
        if (ai != null) {
            for (String name : ai.getLoggers()) {
                Logger logger = this.loggerContext.getLogger(name);
                logger.detachAppender(ai.appender);
            }
        }
    }

    private void attachAppender(AppenderInfo ai) {
        if (ai != null) {
            for (String name : ai.getLoggers()) {
                Logger logger = this.loggerContext.getLogger(name);
                logger.addAppender(ai.appender);
            }
        }
    }

    @Override
    public void onResetStart(LoggerContext context) {
        this.attachAppenders();
    }

    @Override
    public void onResetComplete(LoggerContext context) {
        Map appenderRefBag = (Map)context.getObject(OsgiAppenderRefInternalAction.OSGI_APPENDER_REF_BAG);
        if (appenderRefBag == null) {
            appenderRefBag = Collections.emptyMap();
        }
        this.appenderNameToLoggerMap.clear();
        this.appenderNameToLoggerMap.putAll(appenderRefBag);
        this.attachAppenders();
    }

    public synchronized void close() {
        super.close();
        this.appenders.clear();
    }

    private void attachAppenders() {
        for (AppenderInfo ai : this.appenders.values()) {
            this.attachAppender(ai);
        }
    }

    private static Filter createFilter() throws InvalidSyntaxException {
        String filter = String.format("(&(objectClass=%s)(%s=*))", Appender.class.getName(), PROP_LOGGER);
        return FrameworkUtil.createFilter((String)filter);
    }

    class AppenderInfo {
        private final List<String> loggers;
        final Appender<ILoggingEvent> appender;
        final String pid;
        final String name;

        public AppenderInfo(ServiceReference ref, Appender<ILoggingEvent> appender) {
            this.appender = appender;
            this.pid = ref.getProperty("service.id").toString();
            ArrayList<String> loggers = new ArrayList<String>();
            for (String logger : Util.toList(ref.getProperty(AppenderTracker.PROP_LOGGER))) {
                loggers.add(logger);
            }
            this.loggers = loggers;
            this.name = appender.getName();
        }

        public Set<String> getLoggers() {
            Set loggersFromConfig;
            HashSet<String> result = new HashSet<String>(this.loggers);
            if (this.name != null && (loggersFromConfig = (Set)AppenderTracker.this.appenderNameToLoggerMap.get(this.name)) != null) {
                result.addAll(loggersFromConfig);
            }
            return Collections.unmodifiableSet(result);
        }
    }
}

