/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.helpers.Transform;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.sling.commons.log.logback.internal.AppenderTracker;
import org.apache.sling.commons.log.logback.internal.ConfigSourceTracker;
import org.apache.sling.commons.log.logback.internal.FilteringListener;
import org.apache.sling.commons.log.logback.internal.LogConfig;
import org.apache.sling.commons.log.logback.internal.LogConfigManager;
import org.apache.sling.commons.log.logback.internal.LogWriter;
import org.apache.sling.commons.log.logback.internal.LogbackManager;
import org.apache.sling.commons.log.logback.internal.SlingConfigurationPrinter;
import org.apache.sling.commons.log.logback.internal.Tailer;
import org.apache.sling.commons.log.logback.internal.config.ConfigurationException;
import org.apache.sling.commons.log.logback.internal.util.SlingRollingFileAppender;
import org.apache.sling.commons.log.logback.internal.util.Util;
import org.apache.sling.commons.log.logback.internal.util.XmlUtil;
import org.apache.sling.commons.log.logback.webconsole.LogPanel;
import org.apache.sling.commons.log.logback.webconsole.LoggerConfig;
import org.apache.sling.commons.log.logback.webconsole.TailerOptions;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class SlingLogPanel
implements LogPanel {
    private final CachingDateFormatter SDF = new CachingDateFormatter("yyyy-MM-dd HH:mm:ss");
    private static final String[] LEVEL_NAMES = new String[]{Level.ERROR.levelStr, Level.WARN.levelStr, Level.INFO.levelStr, Level.DEBUG.levelStr, Level.TRACE.levelStr, Level.OFF.levelStr, "DEFAULT"};
    private static final String PACKAGE_SEPARATOR = ".";
    private final LogbackManager logbackManager;
    private final BundleContext bundleContext;
    private static final Logger log = LoggerFactory.getLogger(SlingLogPanel.class);

    public SlingLogPanel(LogbackManager logbackManager, BundleContext bundleContext) {
        this.logbackManager = logbackManager;
        this.bundleContext = bundleContext;
    }

    @Override
    public void tail(PrintWriter pw, String appenderName, TailerOptions options) throws IOException {
        LogbackManager.LoggerStateContext ctx = this.logbackManager.determineLoggerState();
        this.renderAppenderContent(ctx, pw, appenderName, options);
    }

    @Override
    public void render(PrintWriter pw, String consoleAppRoot) throws IOException {
        LogbackManager.LoggerStateContext ctx = this.logbackManager.determineLoggerState();
        this.appendLoggerStatus(pw, ctx);
        this.appendOsgiConfiguredLoggerData(pw, consoleAppRoot);
        this.appendOtherLoggerData(pw, ctx);
        this.addAppenderData(pw, consoleAppRoot, ctx);
        this.appendTurboFilterData(pw, consoleAppRoot, ctx);
        this.appendLogbackMainConfig(pw);
        this.appendLogbackFragments(pw, consoleAppRoot);
        this.appendLogbackStatus(pw, ctx);
        this.addScriptBlock(pw, ctx);
    }

    @Override
    public void deleteLoggerConfig(String pid) {
        try {
            this.removeLogger(pid);
        }
        catch (ConfigurationException e) {
            this.internalFailure("", e);
        }
    }

    @Override
    public void createLoggerConfig(LoggerConfig config) throws IOException {
        try {
            this.configureLogger(config.getPid(), config.getLogLevel(), config.getLoggers(), config.getLogFile(), config.isAdditive());
        }
        catch (ConfigurationException e) {
            this.internalFailure("", e);
        }
    }

    private void addScriptBlock(PrintWriter pw, LogbackManager.LoggerStateContext ctx) {
        pw.println("<script type=\"text/javascript\" src=\"slinglog/res/ui/slinglog.js\"></script>");
        pw.println("<script type=\"text/javascript\" src=\"slinglog/res/ui/jquery.autocomplete.min.js\"></script>");
        pw.println("<script type=\"text/javascript\" src=\"slinglog/res/ui/prettify.js\"></script>");
        pw.println("<script type=\"text/javascript\">$(document).ready(function() { initializeSlingLogPanel(); });</script>");
        pw.println("<script>");
        pw.println("var loggers=[");
        TreeSet<String> loggers = new TreeSet<String>();
        for (ch.qos.logback.classic.Logger logger : ctx.loggerContext.getLoggerList()) {
            loggers.add(logger.getName());
        }
        TreeSet<String> packageList = new TreeSet<String>();
        for (String logger : loggers) {
            int pos = logger.lastIndexOf(PACKAGE_SEPARATOR);
            if (pos == -1) continue;
            String pack = logger.substring(0, pos);
            packageList.add(pack);
        }
        loggers.addAll(packageList);
        Iterator loggerIt = loggers.iterator();
        while (loggerIt.hasNext()) {
            String logger;
            logger = (String)loggerIt.next();
            pw.print("'");
            pw.print(XmlUtil.escapeXml(logger));
            pw.print("'");
            if (!loggerIt.hasNext()) continue;
            pw.print(",");
        }
        pw.println("];");
        pw.println("</script>");
        pw.println("<script>$(document).ready(prettyPrint);</script>");
    }

    private void appendLoggerStatus(PrintWriter pw, LogbackManager.LoggerStateContext ctx) {
        pw.printf("<p class='statline'>Log Service Stats: %d categories, %d appender, %d Dynamic appenders</p>%n", ctx.getNumberOfLoggers(), ctx.getNumOfAppenders(), ctx.getNumOfDynamicAppenders());
    }

    private void appendOsgiConfiguredLoggerData(PrintWriter pw, String consoleAppRoot) {
        pw.println("<div class='table'>");
        pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>Logger (Configured via OSGi Config)</div>");
        pw.println("<form method='POST'><table id=\"loggerConfig\" class='tablesorter nicetable ui-widget'>");
        pw.println("<thead class='ui-widget-header'>");
        pw.println("<tr>");
        pw.println("<th>Log Level</th>");
        pw.println("<th>Additive</th>");
        pw.println("<th>Log File</th>");
        pw.println("<th>Logger</th>");
        pw.print("<th width=\"20%\">");
        pw.print(SlingLogPanel.getConfigColTitle(consoleAppRoot));
        pw.println("</th>");
        pw.println("</tr>");
        pw.println("</thead>");
        pw.println("<tbody class='ui-widget-content'>");
        LogConfigManager configManager = this.logbackManager.getLogConfigManager();
        String rootPath = this.logbackManager.getRootDir();
        boolean shortenPaths = this.areAllLogfilesInSameFolder(configManager.getLogWriters(), rootPath);
        for (LogConfig logConfig : configManager.getLogConfigs()) {
            pw.print("<tr id=\"");
            pw.print(XmlUtil.escapeXml(logConfig.getConfigPid()));
            pw.println("\">");
            pw.print("<td><span class=\"logLevels\" data-currentloglevel=\"");
            pw.print(this.getLevelStr(logConfig));
            pw.print("\">");
            pw.print(this.getLevelStr(logConfig));
            pw.println("</span></td>");
            pw.print("<td><span class=\"logAdditive\" data-currentAdditivity=\"");
            pw.print(Boolean.toString(logConfig.isAdditive()));
            pw.print("\">");
            pw.print(Boolean.toString(logConfig.isAdditive()));
            pw.println("</span></td>");
            pw.print("<td><span class=\"logFile\">");
            pw.print(XmlUtil.escapeXml(SlingLogPanel.getPath(logConfig.getLogWriterName(), rootPath, shortenPaths)));
            pw.println("</span></td>");
            pw.println("<td><span class=\"loggers\">");
            String sep = "";
            for (String cat : logConfig.getCategories()) {
                pw.print(sep);
                pw.print("<span class=\"logger\">");
                pw.print(XmlUtil.escapeXml(cat));
                pw.println("</span>");
                sep = "<br />";
            }
            pw.println("</td>");
            String pid = logConfig.getConfigPid();
            String url = SlingLogPanel.createUrl(consoleAppRoot, "configMgr", pid, true);
            if (logConfig.getCategories().contains("ROOT")) {
                url = SlingLogPanel.createUrl(consoleAppRoot, "configMgr", pid, false);
            }
            pw.print("<td>");
            pw.print(url);
            pw.println("</td>");
            pw.println("</tr>");
        }
        pw.println("</tbody><tfoot>");
        pw.println("<tr id=\"newlogger\">");
        pw.println("<td><span id=\"allLogLevels\" class=\"logLevels\" data-loglevels=\"");
        String sep = "";
        for (String levelName : LEVEL_NAMES) {
            pw.print(sep);
            pw.print(XmlUtil.escapeXml(levelName));
            sep = ",";
        }
        pw.println("\"></span></td>");
        pw.print("<td><span class=\"logAdditive\" data-currentAdditivity=\"false\"></span></td>");
        pw.print("<td><span id=\"defaultLogfile\" data-defaultlogfile=\"");
        pw.print(XmlUtil.escapeXml(SlingLogPanel.getPath(configManager.getDefaultWriter().getFileName(), rootPath, shortenPaths)));
        pw.println("\" class=\"logFile\"></span></td>");
        pw.println("<td><span class=\"loggers\"></span></td>");
        pw.println("<td><input type='submit' class=\"configureLink\" value='Add new Logger' /></td></tr></tfoot>");
        pw.println("</table></form>");
        pw.println("</div>");
    }

    private void appendOtherLoggerData(PrintWriter pw, LogbackManager.LoggerStateContext ctx) throws UnsupportedEncodingException {
        if (ctx.nonOSgiConfiguredLoggers.isEmpty()) {
            return;
        }
        pw.println("<div class='table'>");
        pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>Logger (Configured via other means)</div>");
        pw.println("<table class='nicetable ui-widget'>");
        pw.println("<thead class='ui-widget-header'>");
        pw.println("<tr>");
        pw.println("<th>Log Level</th>");
        pw.println("<th>Additivity</th>");
        pw.println("<th>Name</th>");
        pw.println("<th>Appender</th>");
        pw.println("</tr>");
        pw.println("</thead>");
        pw.println("<tbody class='ui-widget-content'>");
        for (ch.qos.logback.classic.Logger logger : ctx.nonOSgiConfiguredLoggers) {
            pw.println("<tr>");
            pw.print("<td>");
            pw.print(logger.getLevel());
            pw.println("</td>");
            pw.print("<td>");
            pw.print(Boolean.toString(logger.isAdditive()));
            pw.println("</td>");
            pw.print("<td>");
            pw.print(XmlUtil.escapeXml(logger.getName()));
            pw.println("</td>");
            pw.println("<td>");
            pw.println("<ul>");
            Iterator itr = logger.iteratorForAppenders();
            while (itr.hasNext()) {
                Appender a = (Appender)itr.next();
                pw.print("<li>");
                pw.print(XmlUtil.escapeXml(SlingLogPanel.getName((Appender<ILoggingEvent>)a)));
                pw.print("</li>");
            }
            pw.println("</ul>");
            pw.println("</td>");
            pw.println("</tr>");
        }
        pw.println("</tbody>");
        pw.println("</table>");
        pw.println("</div>");
    }

    private void addAppenderData(PrintWriter pw, String consoleAppRoot, LogbackManager.LoggerStateContext ctx) throws UnsupportedEncodingException {
        pw.println("<div class='table'>");
        pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>Appender</div>");
        pw.println("<table class='nicetable ui-widget'>");
        pw.println("<thead class='ui-widget-header'>");
        pw.println("<tr>");
        pw.println("<th>Appender</th>");
        pw.print("<th>");
        pw.print(SlingLogPanel.getConfigColTitle(consoleAppRoot));
        pw.println("</th>");
        pw.println("</tr>");
        pw.println("</thead>");
        pw.println("<tbody class='ui-widget-content'>");
        for (Appender<ILoggingEvent> appender : ctx.appenders.values()) {
            pw.println("<tr>");
            pw.print("<td>");
            if (appender instanceof FileAppender) {
                pw.print(this.getLinkedName((FileAppender<ILoggingEvent>)((FileAppender)appender)));
            } else {
                pw.print(XmlUtil.escapeXml(SlingLogPanel.getName(appender)));
            }
            pw.println("</td>");
            pw.print("<td>");
            pw.print(SlingLogPanel.formatPid(consoleAppRoot, appender, ctx));
            pw.println("</td>");
            pw.println("</tr>");
        }
        pw.println("</tbody>");
        pw.println("</table>");
        pw.println("</div>");
    }

    private void appendTurboFilterData(PrintWriter pw, String consoleAppRoot, LogbackManager.LoggerStateContext ctx) {
        if (ctx.loggerContext.getTurboFilterList().isEmpty()) {
            return;
        }
        pw.println("<div class='table'>");
        pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>Turbo Filters</div>");
        pw.println("<table class='nicetable ui-widget'>");
        pw.println("<thead class='ui-widget-header'>");
        pw.println("<tr>");
        pw.println("<th>Turbo Filter</th>");
        pw.print("<th>");
        pw.print(SlingLogPanel.getConfigColTitle(consoleAppRoot));
        pw.println("</th>");
        pw.println("</tr>");
        pw.println("</thead>");
        pw.println("<tbody class='ui-widget-content'>");
        for (TurboFilter tf : ctx.loggerContext.getTurboFilterList()) {
            pw.println("<tr>");
            pw.println("<td>");
            pw.print(XmlUtil.escapeXml(SlingLogPanel.getName(tf)));
            pw.println("</td>");
            pw.print("<td>");
            pw.print(SlingLogPanel.formatPid(consoleAppRoot, tf, ctx));
            pw.println("</td>");
            pw.println("</tr>");
        }
        pw.println("</tbody>");
        pw.println("</table>");
        pw.println("</div>");
    }

    private void appendLogbackStatus(PrintWriter pw, LogbackManager.LoggerStateContext ctx) {
        pw.println("<div class='table'>");
        pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>Logback Status</div>");
        pw.println("<div style='overflow-y:scroll; height:400px'>");
        pw.println("<table class='nicetable ui-widget'>");
        pw.println("<thead class='ui-widget-header'>");
        pw.println("<tr>");
        pw.println("<th>Date</th>");
        pw.println("<th>Level</th>");
        pw.println("<th>Origin</th>");
        pw.println("<th>Message</th>");
        pw.println("</tr>");
        pw.println("</thead>");
        pw.println("<tbody class='ui-widget-content'  >");
        List statusList = ctx.loggerContext.getStatusManager().getCopyOfStatusList();
        for (Status s : statusList) {
            pw.println("<tr>");
            pw.print("<td class=\"date\">");
            pw.print(this.SDF.format(s.getDate().longValue()));
            pw.println("</td>");
            pw.print("<td class=\"level\">");
            pw.print(SlingLogPanel.statusLevelAsString(s));
            pw.println("</td>");
            pw.print("<td>");
            pw.print(XmlUtil.escapeXml(SlingConfigurationPrinter.abbreviatedOrigin(s)));
            pw.println("</td>");
            pw.print("<td>");
            pw.print(XmlUtil.escapeXml(s.getMessage()));
            pw.println("</td>");
            pw.println("</tr>");
            if (s.getThrowable() == null) continue;
            SlingLogPanel.printThrowable(pw, s.getThrowable());
        }
        pw.println("</tbody>");
        pw.println("</table>");
        pw.print("</div>");
        pw.println("</div>");
        pw.println("<br />");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendLogbackMainConfig(PrintWriter pw) {
        pw.println("<div class='table'>");
        pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>Logback Config</div>");
        pw.println("<table class='nicetable ui-widget'>");
        pw.println("<tbody class='ui-widget-content'>");
        File configFile = null;
        URL url = null;
        InputSource source = null;
        try {
            String msg;
            configFile = this.logbackManager.getLogConfigManager().getLogbackConfigFile();
            if (configFile != null) {
                source = new InputSource(new BufferedInputStream(new FileInputStream(configFile)));
                msg = "Source " + configFile.getAbsolutePath();
            } else {
                url = this.logbackManager.getDefaultConfig();
                URLConnection uc = url.openConnection();
                uc.setDefaultUseCaches(false);
                source = new InputSource(new BufferedInputStream(uc.getInputStream()));
                msg = "Source : Default";
            }
            pw.println("<tr>");
            pw.print("<td>");
            pw.print(XmlUtil.escapeXml(msg));
            pw.println("</td>");
            pw.println("</tr>");
            pw.println("<tr><td>");
            String textContent = XmlUtil.escapeXml(XmlUtil.prettyPrint(source));
            pw.print("<pre class=\"prettyprint lang-xml\" style=\"border: 0px\">");
            pw.print(textContent);
            pw.print("</pre>");
            pw.println("</td></tr>");
        }
        catch (IOException e) {
            try {
                String msg = "Error occurred while opening file [" + configFile + "]";
                if (url != null) {
                    msg = "Error occurred while opening url [" + url + "]";
                }
                log.warn(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                Util.close(source);
                throw throwable;
            }
            Util.close(source);
        }
        Util.close(source);
        pw.println("</tbody>");
        pw.println("</table>");
        pw.println("</div>");
    }

    private void appendLogbackFragments(PrintWriter pw, String consoleAppRoot) {
        Collection<ConfigSourceTracker.ConfigSourceInfo> configSources = this.logbackManager.getConfigSourceTracker().getSources();
        if (configSources.isEmpty()) {
            return;
        }
        pw.println("<div class='table'>");
        pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>Logback Config Fragments</div>");
        pw.println("<table class='nicetable ui-widget'>");
        pw.println("<tbody class='ui-widget-content'>");
        for (ConfigSourceTracker.ConfigSourceInfo ci : configSources) {
            String pid = ci.getReference().getProperty("service.id").toString();
            String url = SlingLogPanel.createUrl(consoleAppRoot, "services", pid);
            pw.println("<tr>");
            pw.print("<td>");
            pw.print(url);
            pw.println("</td>");
            pw.println("</tr>");
            pw.println("<tr>");
            pw.println("<td>");
            pw.print("<pre class=\"prettyprint lang-xml\" style=\"border: 0px\">");
            pw.print(ci.getSourceAsEscapedString());
            pw.print("</pre>");
            pw.println("</td>");
            pw.println("</tr>");
        }
        pw.println("</tbody>");
        pw.println("</table>");
        pw.println("</div>");
    }

    private boolean areAllLogfilesInSameFolder(Iterable<LogWriter> logWriters, String rootPath) {
        String lastPath = null;
        for (LogWriter writer : logWriters) {
            String path = SlingLogPanel.getPath(writer.getFileName(), null, false);
            if (!path.startsWith(rootPath)) {
                return false;
            }
            path = path.substring(0, rootPath.length());
            if (lastPath == null) {
                lastPath = path;
                continue;
            }
            if (path.equals(lastPath)) continue;
            return false;
        }
        return true;
    }

    private void renderAppenderContent(LogbackManager.LoggerStateContext ctx, PrintWriter pw, String appenderName, TailerOptions opts) throws IOException {
        for (Appender<ILoggingEvent> appender : ctx.appenders.values()) {
            if (!(appender instanceof FileAppender) || !appenderName.equals(appender.getName())) continue;
            File file = new File(((FileAppender)appender).getFile());
            if (file.exists()) {
                if (opts.tailAll()) {
                    SlingConfigurationPrinter.includeWholeFile(pw, file);
                } else {
                    int numOfLines = opts.getNumOfLines();
                    if (numOfLines == 0) {
                        numOfLines = this.logbackManager.getLogConfigManager().getNumOfLines();
                    }
                    new Tailer(new FilteringListener(pw, opts.getRegex()), numOfLines).tail(file);
                }
            }
            return;
        }
        pw.printf("No appender with name [%s] found", appenderName);
    }

    private String getLinkedName(FileAppender<ILoggingEvent> appender) throws UnsupportedEncodingException {
        String fileName = appender.getFile();
        String name = appender.getName();
        return String.format("File : [<a href=\"%s/%s?%s=%d&%s=%s&%s=%s\">%s</a>] %s", "slinglog", "tailer.txt", "tail", this.logbackManager.getLogConfigManager().getNumOfLines(), "grep", "*", "name", URLEncoder.encode(name, "UTF-8"), XmlUtil.escapeXml(name), XmlUtil.escapeXml(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureLogger(String pid, String logLevel, String[] loggers, String logFile, boolean additive) throws IOException, ConfigurationException {
        ServiceReference sr = this.bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        if (sr != null) {
            try {
                Configuration config;
                if (logLevel == null) {
                    throw new ConfigurationException("org.apache.sling.commons.log.level", "Log level has to be specified.");
                }
                if (loggers == null) {
                    throw new ConfigurationException("org.apache.sling.commons.log.names", "Logger categories have to be specified.");
                }
                if (logFile == null) {
                    throw new ConfigurationException("org.apache.sling.commons.log.file", "LogFile name has to be specified.");
                }
                ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.bundleContext.getService(sr);
                if (configAdmin != null && (config = pid == null || pid.length() == 0 ? configAdmin.createFactoryConfiguration("org.apache.sling.commons.log.LogManager.factory.config") : configAdmin.getConfiguration(pid)) != null) {
                    Hashtable<String, Object> dict = new Hashtable<String, Object>();
                    ((Dictionary)dict).put("org.apache.sling.commons.log.level", logLevel.toLowerCase());
                    ((Dictionary)dict).put("org.apache.sling.commons.log.names", loggers);
                    ((Dictionary)dict).put("org.apache.sling.commons.log.file", logFile);
                    if (additive) {
                        ((Dictionary)dict).put("org.apache.sling.commons.log.additiv", "true");
                    } else {
                        ((Dictionary)dict).put("org.apache.sling.commons.log.additiv", "false");
                    }
                    config.update(dict);
                }
            }
            finally {
                this.bundleContext.ungetService(sr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLogger(String pid) throws ConfigurationException {
        block8: {
            ServiceReference sr = this.bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
            if (sr != null) {
                try {
                    if (pid == null) {
                        throw new ConfigurationException("org.apache.sling.commons.log.LogManager", "PID has to be specified.");
                    }
                    ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.bundleContext.getService(sr);
                    if (configAdmin == null) break block8;
                    try {
                        Configuration config = configAdmin.getConfiguration(pid);
                        if (config != null) {
                            config.delete();
                            break block8;
                        }
                        throw new ConfigurationException("org.apache.sling.commons.log.LogManager", "No configuration for this PID:" + pid);
                    }
                    catch (IOException ioe) {
                        this.internalFailure("Cannot delete configuration for pid " + pid, ioe);
                    }
                }
                finally {
                    this.bundleContext.ungetService(sr);
                }
            }
        }
    }

    private void internalFailure(String msg, Exception e) {
        this.logbackManager.getLogConfigManager().internalFailure(msg, e);
    }

    private String getLevelStr(LogConfig logConfig) {
        if (logConfig.isResetToDefault()) {
            return "DEFAULT";
        }
        return logConfig.getLogLevel().levelStr;
    }

    private static String getName(TurboFilter tf) {
        if (tf.getName() != null) {
            return String.format("%s (%s)", tf.getName(), tf.getClass().getName());
        }
        return tf.getClass().getName();
    }

    private static String formatPid(String consoleAppRoot, TurboFilter tf, LogbackManager.LoggerStateContext ctx) {
        ServiceReference sr = ctx.getTurboFilterRef(tf);
        if (sr != null) {
            String pid = sr.getProperty("service.id").toString();
            return SlingLogPanel.createUrl(consoleAppRoot, "services", pid);
        }
        return "[config]";
    }

    private static String getName(Appender<ILoggingEvent> appender) throws UnsupportedEncodingException {
        if (appender instanceof FileAppender) {
            return String.format("File : [%s] %s", appender.getName(), ((FileAppender)appender).getFile());
        }
        String appenderName = appender.getName();
        if (appenderName == null) {
            return appender.getClass().getName();
        }
        return String.format("%s (%s)", appender.getName(), appender.getClass().getName());
    }

    private static String formatPid(String consoleAppRoot, Appender<ILoggingEvent> appender, LogbackManager.LoggerStateContext ctx) {
        if (appender instanceof SlingRollingFileAppender) {
            LogWriter lw = ((SlingRollingFileAppender)appender).getLogWriter();
            String pid = lw.getConfigurationPID();
            if (lw.isImplicit()) {
                pid = lw.getImplicitConfigPID();
            }
            return SlingLogPanel.createUrl(consoleAppRoot, "configMgr", pid);
        }
        if (ctx.isDynamicAppender(appender)) {
            AppenderTracker.AppenderInfo ai = ctx.dynamicAppenders.get(appender);
            String pid = ai.pid;
            return SlingLogPanel.createUrl(consoleAppRoot, "services", pid);
        }
        return "[others]";
    }

    private static String getConfigColTitle(String consoleAppRoot) {
        return consoleAppRoot == null ? "PID" : "Configuration";
    }

    private static String createUrl(String consoleAppRoot, String subContext, String pid) {
        return SlingLogPanel.createUrl(consoleAppRoot, subContext, pid, false);
    }

    private static String createUrl(String consoleAppRoot, String subContext, String pid, boolean inlineEditable) {
        if (consoleAppRoot == null) {
            return "<a href=\"" + subContext + "/" + XmlUtil.escapeXml(pid) + "\">" + XmlUtil.escapeXml(pid) + "</a>";
        }
        String classAttr = "class=\"configureLink\"";
        if (!inlineEditable) {
            classAttr = "";
        }
        return "<a " + classAttr + " href=\"" + subContext + "/" + XmlUtil.escapeXml(pid) + "\"><img src=\"" + consoleAppRoot + "/res/imgs/component_configure.png\" border=\"0\" /></a>";
    }

    private static String getPath(String path, String rootPath, boolean shortenPaths) {
        if (shortenPaths && path != null) {
            path = path.substring(rootPath.length() + 1);
        }
        return path != null ? path : "[stdout]";
    }

    private static String statusLevelAsString(Status s) {
        switch (s.getEffectiveLevel()) {
            case 0: {
                return "INFO";
            }
            case 1: {
                return "<span class=\"warn\">WARN</span>";
            }
            case 2: {
                return "<span class=\"error\">ERROR</span>";
            }
        }
        return null;
    }

    private static void printThrowable(PrintWriter pw, Throwable t) {
        pw.println("  <tr>");
        pw.println("    <td colspan=\"4\" class=\"exception\"><pre>");
        StringWriter sw = new StringWriter();
        PrintWriter expPw = new PrintWriter(sw);
        t.printStackTrace(expPw);
        pw.println(Transform.escapeTags((StringBuffer)sw.getBuffer()));
        pw.println("    </pre></td>");
        pw.println("  </tr>");
    }
}

