/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Context;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.commons.log.logback.internal.LogbackResetListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class TurboFilterTracker
extends ServiceTracker
implements LogbackResetListener {
    private final LoggerContext loggerContext;
    private final Map<ServiceReference, TurboFilter> filters = new ConcurrentHashMap<ServiceReference, TurboFilter>();

    public TurboFilterTracker(BundleContext context, LoggerContext loggerContext) {
        super(context, TurboFilter.class.getName(), null);
        this.loggerContext = loggerContext;
    }

    public Object addingService(ServiceReference reference) {
        TurboFilter tf = (TurboFilter)super.addingService(reference);
        tf.setContext((Context)this.loggerContext);
        tf.start();
        this.attachFilter(tf);
        this.filters.put(reference, tf);
        return tf;
    }

    public void removedService(ServiceReference reference, Object service) {
        TurboFilter tf = (TurboFilter)service;
        this.filters.remove(reference);
        this.loggerContext.getTurboFilterList().remove((Object)tf);
        super.removedService(reference, service);
    }

    @Override
    public void onResetStart(LoggerContext context) {
        for (TurboFilter tf : this.filters.values()) {
            this.attachFilter(tf);
        }
    }

    public synchronized void close() {
        super.close();
        this.filters.clear();
    }

    @Override
    public void onResetComplete(LoggerContext context) {
    }

    public Map<ServiceReference, TurboFilter> getFilters() {
        return Collections.unmodifiableMap(this.filters);
    }

    private void attachFilter(TurboFilter tf) {
        if (!this.loggerContext.getTurboFilterList().contains((Object)tf)) {
            this.loggerContext.addTurboFilter(tf);
        }
    }
}

