/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.LoggerContext;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.sling.commons.log.logback.ConfigProvider;
import org.apache.sling.commons.log.logback.internal.LogbackManager;
import org.apache.sling.commons.log.logback.internal.LogbackResetListener;
import org.apache.sling.commons.log.logback.internal.util.XmlUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.xml.sax.InputSource;

public class ConfigSourceTracker
extends ServiceTracker
implements LogbackResetListener {
    private static final String PROP_LOGBACK_CONFIG = "logbackConfig";
    private final Map<ServiceReference, ConfigSourceInfo> inputSources = new ConcurrentSkipListMap(Collections.reverseOrder());
    private final LogbackManager logbackManager;

    public ConfigSourceTracker(BundleContext context, LogbackManager logbackManager) throws InvalidSyntaxException {
        super(context, ConfigSourceTracker.createFilter(), null);
        this.logbackManager = logbackManager;
        super.open();
    }

    public Collection<ConfigSourceInfo> getSources() {
        return this.inputSources.values();
    }

    public synchronized void close() {
        super.close();
        this.inputSources.clear();
    }

    public Object addingService(ServiceReference reference) {
        Object o = super.addingService(reference);
        this.inputSources.put(reference, new ConfigSourceInfo(reference, ConfigSourceTracker.getConfig(o)));
        this.logbackManager.configChanged();
        return o;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        super.modifiedService(reference, service);
        this.logbackManager.configChanged();
    }

    public void removedService(ServiceReference reference, Object service) {
        if (this.inputSources.remove(reference) != null) {
            this.logbackManager.configChanged();
        }
    }

    @Override
    public void onResetStart(LoggerContext context) {
        context.putObject(ConfigSourceTracker.class.getName(), this);
    }

    @Override
    public void onResetComplete(LoggerContext context) {
    }

    private static ConfigProvider getConfig(Object o) {
        if (o instanceof String) {
            return new StringSourceProvider((String)o);
        }
        return (ConfigProvider)o;
    }

    private static Filter createFilter() throws InvalidSyntaxException {
        String filter = String.format("(|(objectClass=%s)(&(objectClass=java.lang.String)(%s=*)))", ConfigProvider.class.getName(), PROP_LOGBACK_CONFIG);
        return FrameworkUtil.createFilter((String)filter);
    }

    private static class StringSourceProvider
    implements ConfigProvider {
        private final String source;

        private StringSourceProvider(String source) {
            this.source = source;
        }

        @Override
        public InputSource getConfigSource() {
            return new InputSource(new StringReader(this.source));
        }
    }

    public static class ConfigSourceInfo {
        private final ServiceReference reference;
        private final ConfigProvider configProvider;

        public ConfigSourceInfo(ServiceReference reference, ConfigProvider configProvider) {
            this.reference = reference;
            this.configProvider = configProvider;
        }

        public ConfigProvider getConfigProvider() {
            return this.configProvider;
        }

        public ServiceReference getReference() {
            return this.reference;
        }

        public String getSourceAsString() {
            return XmlUtil.prettyPrint(this.getConfigProvider().getConfigSource());
        }

        public String getSourceAsEscapedString() {
            return XmlUtil.escapeXml(this.getSourceAsString());
        }

        public String toString() {
            return String.format("Service ID %s", this.reference.getProperty("service.id"));
        }
    }
}

