/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.pattern.PostCompileProcessor;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.commons.log.logback.internal.LogWriter;
import org.apache.sling.commons.log.logback.internal.MaskingMessageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogConfig {
    private static final String[] LEGACY_MARKERS = new String[]{"{0}", "{1}", "{2}", "{3}", "{4}", "{5}"};
    private static final Logger log = LoggerFactory.getLogger(LogConfig.class);
    private final String configPid;
    private final Set<String> categories;
    private final Level logLevel;
    private final String pattern;
    private final String logWriterName;
    private final LogWriterProvider logWriterProvider;
    private final LoggerContext loggerContext;
    private final boolean isAdditiv;
    private final boolean resetToDefault;
    private PostCompileProcessor<ILoggingEvent> postProcessor;

    LogConfig(LogWriterProvider logWriterProvider, String pattern, Set<String> categories, Level logLevel, String logWriterName, boolean isAdditiv, String configPid, LoggerContext loggerContext, boolean resetToDefault) {
        this.logWriterProvider = logWriterProvider;
        this.configPid = configPid;
        this.pattern = pattern;
        this.categories = Collections.unmodifiableSet(categories);
        this.logLevel = logLevel;
        this.logWriterName = logWriterName;
        this.loggerContext = loggerContext;
        this.isAdditiv = isAdditiv;
        this.resetToDefault = resetToDefault;
    }

    public String getConfigPid() {
        return this.configPid;
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public String getLogWriterName() {
        return this.logWriterName;
    }

    public boolean isAppenderDefined() {
        return this.logWriterName != null;
    }

    public boolean isAdditive() {
        return this.isAdditiv;
    }

    public LogWriter getLogWriter() {
        return this.logWriterProvider.getLogWriter(this.getLogWriterName());
    }

    public boolean isResetToDefault() {
        return this.resetToDefault;
    }

    public PatternLayout createLayout() {
        Pattern date = Pattern.compile("\\{0,date,(.+?)\\}");
        Matcher m = date.matcher(this.pattern);
        String logBackPattern = this.pattern;
        if (m.matches()) {
            logBackPattern = m.replaceAll("%d'{'$1'}'");
        }
        boolean legacyPattern = false;
        for (String marker : LEGACY_MARKERS) {
            if (!logBackPattern.contains(marker)) continue;
            legacyPattern = true;
            break;
        }
        if (legacyPattern) {
            try {
                logBackPattern = MessageFormat.format(logBackPattern, "zero", "%marker", "%thread", "%logger", "%level", "%message") + "%n";
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid message format provided [{}]. Would use the default pattern", (Object)logBackPattern, (Object)e);
                logBackPattern = "%d{dd.MM.yyyy HH:mm:ss.SSS} *%level* [%thread] %logger %msg%n";
            }
        }
        PatternLayout pl = new PatternLayout();
        pl.setPattern(logBackPattern);
        pl.setOutputPatternAsHeader(false);
        pl.setContext(this.loggerContext);
        MaskingMessageUtil.setMessageConverter(pl);
        if (this.postProcessor != null) {
            pl.setPostCompileProcessor(this.postProcessor);
        }
        pl.start();
        return pl;
    }

    public String toString() {
        return "LogConfig{configPid='" + this.configPid + '\'' + ", categories=" + this.categories + ", logLevel=" + this.logLevel + ", logWriterName='" + this.logWriterName + '\'' + '}';
    }

    public void setPostProcessor(PostCompileProcessor<ILoggingEvent> postProcessor) {
        this.postProcessor = postProcessor;
    }

    public static interface LogWriterProvider {
        public LogWriter getLogWriter(String var1);
    }
}

