/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal.util;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.sling.commons.log.logback.internal.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class XmlUtil {
    private static Logger log = LoggerFactory.getLogger(XmlUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prettyPrint(InputSource is) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StreamResult result = new StreamResult(new StringWriter());
            SAXSource source = new SAXSource(is);
            transformer.transform(source, result);
            String string = result.getWriter().toString();
            return string;
        }
        catch (Exception e) {
            log.warn("Error occurred while transforming xml", (Throwable)e);
        }
        finally {
            Util.close(is);
        }
        return "Source not found";
    }

    public static String escapeXml(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '&') {
                b.append("&amp;");
                continue;
            }
            if (c == '<') {
                b.append("&lt;");
                continue;
            }
            if (c == '>') {
                b.append("&gt;");
                continue;
            }
            if (c == '\"') {
                b.append("&quot;");
                continue;
            }
            if (c == '\'') {
                b.append("&apos;");
                continue;
            }
            b.append(c);
        }
        return b.toString().replaceAll("\\$", "&#37;");
    }
}

