/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.mime.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.commons.mime.MimeTypeProvider;
import org.apache.sling.commons.mime.internal.TikaMimeTypeProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private ServiceRegistration reg;

    public void start(BundleContext context) throws Exception {
        try {
            TikaMimeTypeProvider provider = new TikaMimeTypeProvider();
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("service.description", "Apache Tika MIME Type Provider");
            ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
            this.reg = context.registerService(MimeTypeProvider.class.getName(), (Object)provider, props);
            this.logger.debug("Registered Apache Tika mime type provider");
        }
        catch (Throwable t) {
            this.logger.debug("Unable to register Apache Tika mime type provider", t);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.reg != null) {
            this.reg.unregister();
            this.reg = null;
        }
    }
}

