/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.sling.commons.scheduler.Job;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.commons.scheduler.impl.JobHandler;
import org.apache.sling.commons.scheduler.impl.QuartzJobExecutor;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzScheduler
implements Scheduler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String DEFAULT_QUARTZ_JOB_GROUP = "Sling";
    protected static final String PREFIX = "Apache Sling Quartz Scheduler ";
    protected static final String QUARTZ_SCHEDULER_NAME = "ApacheSling";
    static final String DATA_MAP_OBJECT = "QuartzJobScheduler.Object";
    static final String DATA_MAP_NAME = "QuartzJobScheduler.JobName";
    static final String DATA_MAP_CONFIGURATION = "QuartzJobScheduler.Configuration";
    static final String DATA_MAP_LOGGER = "QuartzJobScheduler.Logger";
    static final String DATA_MAP_JOB_HANDLER = "QuartzJobExecutor.JobHandler";
    protected volatile org.quartz.Scheduler scheduler;
    protected final List<Registration> registeredJobs = new ArrayList<Registration>();
    protected volatile ComponentContext context;
    protected ThreadPoolManager threadPoolManager;
    protected org.apache.sling.commons.threads.ThreadPool threadPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext ctx) throws Exception {
        Registration[] regs;
        this.context = ctx;
        this.scheduler = this.init();
        List<Registration> list = this.registeredJobs;
        synchronized (list) {
            regs = this.registeredJobs.toArray(new Registration[this.registeredJobs.size()]);
            this.registeredJobs.clear();
        }
        for (Registration reg : regs) {
            try {
                this.register(reg.componentName, reg.reference);
            }
            catch (Exception e) {
                this.logger.error("Exception during registering " + reg.componentName + " service " + reg.reference, (Throwable)e);
            }
        }
    }

    protected void deactivate(ComponentContext ctx) {
        org.quartz.Scheduler s = this.scheduler;
        this.scheduler = null;
        this.dispose(s);
        this.context = null;
    }

    protected org.quartz.Scheduler init() throws SchedulerException {
        org.quartz.Scheduler s;
        ThreadPoolManager tpm = this.threadPoolManager;
        if (tpm == null) {
            StdSchedulerFactory factory = new StdSchedulerFactory();
            s = factory.getScheduler();
        } else {
            this.threadPool = tpm.get(null);
            QuartzThreadPool quartzPool = new QuartzThreadPool(this.threadPool);
            DirectSchedulerFactory factory = DirectSchedulerFactory.getInstance();
            String runID = new Date().toString().replace(' ', '_');
            factory.createScheduler(QUARTZ_SCHEDULER_NAME, runID, (ThreadPool)quartzPool, (JobStore)new RAMJobStore());
            Iterator allSchedulersIter = factory.getAllSchedulers().iterator();
            s = null;
            while (s == null && allSchedulersIter.hasNext()) {
                org.quartz.Scheduler current = (org.quartz.Scheduler)allSchedulersIter.next();
                if (!QUARTZ_SCHEDULER_NAME.equals(current.getSchedulerName()) || !runID.equals(current.getSchedulerInstanceId())) continue;
                s = current;
            }
            if (s == null) {
                throw new SchedulerException("Unable to find new scheduler with name ApacheSling and run ID " + runID);
            }
        }
        s.start();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Apache Sling Quartz Scheduler started.");
        }
        return s;
    }

    protected void dispose(org.quartz.Scheduler s) {
        ThreadPoolManager tpm = this.threadPoolManager;
        if (tpm != null && this.threadPool != null) {
            tpm.release(this.threadPool);
            this.threadPool = null;
        }
        if (s != null) {
            try {
                s.shutdown();
            }
            catch (SchedulerException e) {
                this.logger.debug("Exception during shutdown of scheduler.", (Throwable)e);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Apache Sling Quartz Scheduler stopped.");
            }
        }
    }

    protected void scheduleJob(String name, Object job, Map<String, Serializable> config, Trigger trigger, boolean canRunConcurrently) throws SchedulerException {
        org.quartz.Scheduler s = this.scheduler;
        if (s == null) {
            throw new IllegalStateException("Scheduler is not available anymore.");
        }
        this.checkJob(job);
        if (name != null) {
            try {
                JobDetail jobdetail = s.getJobDetail(name, DEFAULT_QUARTZ_JOB_GROUP);
                if (jobdetail != null) {
                    this.removeJob(name);
                }
            }
            catch (SchedulerException ignored) {
                // empty catch block
            }
        }
        String jobName = this.getJobName(name);
        JobDataMap jobDataMap = this.initDataMap(jobName, job, config, canRunConcurrently);
        JobDetail detail = this.createJobDetail(jobName, jobDataMap);
        this.logger.debug("Scheduling job {} with name {} and trigger {}", new Object[]{job, jobName, trigger});
        s.scheduleJob(detail, trigger);
    }

    protected JobDataMap initDataMap(String jobName, Object job, Map<String, Serializable> config, boolean concurrent) {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put((Object)DATA_MAP_OBJECT, job);
        jobDataMap.put(DATA_MAP_NAME, jobName);
        JobHandler handler = new JobHandler(concurrent);
        jobDataMap.put((Object)DATA_MAP_JOB_HANDLER, (Object)handler);
        jobDataMap.put((Object)DATA_MAP_LOGGER, (Object)this.logger);
        if (config != null) {
            jobDataMap.put((Object)DATA_MAP_CONFIGURATION, config);
        }
        return jobDataMap;
    }

    protected JobDetail createJobDetail(String name, JobDataMap jobDataMap) {
        JobDetail detail = new JobDetail(name, DEFAULT_QUARTZ_JOB_GROUP, QuartzJobExecutor.class);
        detail.setJobDataMap(jobDataMap);
        return detail;
    }

    protected void checkJob(Object job) throws IllegalArgumentException {
        if (!(job instanceof Runnable) && !(job instanceof Job)) {
            throw new IllegalArgumentException("Job object is neither an instance of " + Runnable.class.getName() + " nor " + Job.class.getName());
        }
    }

    @Override
    public void addJob(String name, Object job, Map<String, Serializable> config, String schedulingExpression, boolean canRunConcurrently) throws SchedulerException {
        CronTrigger cronJobEntry = new CronTrigger(name, DEFAULT_QUARTZ_JOB_GROUP);
        try {
            cronJobEntry.setCronExpression(schedulingExpression);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Error during parsing of cron '" + schedulingExpression + "' : " + pe.getMessage(), pe);
        }
        this.scheduleJob(name, job, config, (Trigger)cronJobEntry, canRunConcurrently);
    }

    @Override
    public void addPeriodicJob(String name, Object job, Map<String, Serializable> config, long period, boolean canRunConcurrently) throws SchedulerException {
        long ms = period * 1000L;
        String jobName = this.getJobName(name);
        SimpleTrigger timeEntry = new SimpleTrigger(jobName, DEFAULT_QUARTZ_JOB_GROUP, new Date(System.currentTimeMillis() + ms), null, SimpleTrigger.REPEAT_INDEFINITELY, ms);
        this.scheduleJob(jobName, job, config, (Trigger)timeEntry, canRunConcurrently);
    }

    @Override
    public void fireJob(Object job, Map<String, Serializable> config) throws SchedulerException {
        this.checkJob(job);
        String jobName = job.getClass().getName();
        JobDataMap dataMap = this.initDataMap(jobName, job, config, true);
        JobDetail detail = this.createJobDetail(jobName, dataMap);
        SimpleTrigger trigger = new SimpleTrigger(jobName, DEFAULT_QUARTZ_JOB_GROUP);
        this.scheduler.scheduleJob(detail, (Trigger)trigger);
    }

    @Override
    public void fireJobAt(String name, Object job, Map<String, Serializable> config, Date date) throws SchedulerException {
        String jobName = this.getJobName(name);
        SimpleTrigger trigger = new SimpleTrigger(jobName, DEFAULT_QUARTZ_JOB_GROUP, date);
        this.scheduleJob(jobName, job, config, (Trigger)trigger, true);
    }

    @Override
    public boolean fireJob(Object job, Map<String, Serializable> config, int times, long period) {
        this.checkJob(job);
        if (times < 2) {
            throw new IllegalArgumentException("Times argument must be higher than 1");
        }
        long ms = period * 1000L;
        String jobName = job.getClass().getName();
        JobDataMap dataMap = this.initDataMap(jobName, job, config, true);
        JobDetail detail = this.createJobDetail(jobName, dataMap);
        SimpleTrigger trigger = new SimpleTrigger(jobName, DEFAULT_QUARTZ_JOB_GROUP, times, ms);
        try {
            this.scheduler.scheduleJob(detail, (Trigger)trigger);
        }
        catch (SchedulerException se) {
            return false;
        }
        return true;
    }

    @Override
    public boolean fireJobAt(String name, Object job, Map<String, Serializable> config, Date date, int times, long period) {
        if (times < 2) {
            throw new IllegalArgumentException("Times argument must be higher than 1");
        }
        String jobName = job.getClass().getName();
        long ms = period * 1000L;
        SimpleTrigger trigger = new SimpleTrigger(jobName, DEFAULT_QUARTZ_JOB_GROUP, date, null, times, ms);
        try {
            this.scheduleJob(jobName, job, config, (Trigger)trigger, true);
        }
        catch (SchedulerException se) {
            return false;
        }
        return true;
    }

    private String getJobName(String name) {
        return name != null ? name : PREFIX + UUID.randomUUID();
    }

    @Override
    public void removeJob(String name) throws NoSuchElementException {
        org.quartz.Scheduler s = this.scheduler;
        if (s != null) {
            try {
                s.deleteJob(name, DEFAULT_QUARTZ_JOB_GROUP);
                this.logger.debug("Unscheduling job with name {}", (Object)name);
            }
            catch (SchedulerException se) {
                throw new NoSuchElementException(se.getMessage());
            }
        }
    }

    private String getServiceIdentifier(ServiceReference ref) {
        String name = (String)ref.getProperty("scheduler.name");
        if (name == null && (name = (String)ref.getProperty("service.pid")) == null) {
            name = "Registered Service";
        }
        name = name + "." + ref.getProperty("service.id");
        return name;
    }

    private void register(String type, ServiceReference ref) {
        ComponentContext ctx = this.context;
        if (ctx != null) {
            try {
                Object job = ctx.locateService(type, ref);
                if (ref != null) {
                    this.checkJob(job);
                    String name = this.getServiceIdentifier(ref);
                    Boolean concurrent = (Boolean)ref.getProperty("scheduler.concurrent");
                    String expression = (String)ref.getProperty("scheduler.expression");
                    if (expression != null) {
                        this.addJob(name, job, null, expression, concurrent != null ? concurrent : true);
                    } else {
                        Long period = (Long)ref.getProperty("scheduler.period");
                        if (period != null) {
                            this.addPeriodicJob(name, job, null, period, concurrent != null ? concurrent : true);
                        }
                    }
                }
            }
            catch (IllegalStateException e) {
            }
            catch (SchedulerException e) {
                // empty catch block
            }
        }
    }

    private void unregister(ServiceReference ref) {
        try {
            String name = this.getServiceIdentifier(ref);
            this.removeJob(name);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindJob(ServiceReference ref) {
        if (this.scheduler != null) {
            this.register("job", ref);
        } else {
            List<Registration> list = this.registeredJobs;
            synchronized (list) {
                this.registeredJobs.add(new Registration(ref, "job"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindJob(ServiceReference ref) {
        if (this.scheduler != null) {
            this.unregister(ref);
        } else {
            List<Registration> list = this.registeredJobs;
            synchronized (list) {
                this.registeredJobs.remove(new Registration(ref, "job"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindTask(ServiceReference ref) {
        if (this.scheduler != null) {
            this.register("task", ref);
        } else {
            List<Registration> list = this.registeredJobs;
            synchronized (list) {
                this.registeredJobs.add(new Registration(ref, "task"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindTask(ServiceReference ref) {
        if (this.scheduler != null) {
            this.unregister(ref);
        } else {
            List<Registration> list = this.registeredJobs;
            synchronized (list) {
                this.registeredJobs.remove(new Registration(ref, "task"));
            }
        }
    }

    protected void bindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        this.threadPoolManager = threadPoolManager;
    }

    protected void unbindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        if (this.threadPoolManager == threadPoolManager) {
            this.threadPoolManager = null;
        }
    }

    private static final class QuartzThreadPool
    implements ThreadPool {
        private org.apache.sling.commons.threads.ThreadPool executor;

        public QuartzThreadPool(org.apache.sling.commons.threads.ThreadPool executor) {
            this.executor = executor;
        }

        public int getPoolSize() {
            return this.executor.getConfiguration().getMaxPoolSize();
        }

        public void initialize() {
        }

        public boolean runInThread(Runnable job) {
            this.executor.execute(job);
            return true;
        }

        public int blockForAvailableThreads() {
            return this.executor.getConfiguration().getMaxPoolSize() - this.executor.getConfiguration().getQueueSize();
        }

        public void shutdown(boolean waitForJobsToComplete) {
            this.executor = null;
        }
    }

    private static final class Registration {
        public static final String JOB = "job";
        public static final String TASK = "task";
        public final ServiceReference reference;
        public final String componentName;

        public Registration(ServiceReference r, String name) {
            this.reference = r;
            this.componentName = name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Registration)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            return this.reference.equals(((Registration)obj).reference);
        }

        public int hashCode() {
            return this.reference.hashCode();
        }
    }
}

