/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import java.io.Serializable;
import java.util.Map;
import org.apache.sling.commons.scheduler.Job;
import org.apache.sling.commons.scheduler.JobContext;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;

public class QuartzJobExecutor
implements org.quartz.Job {
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap data = context.getJobDetail().getJobDataMap();
        Object job = data.get((Object)"QuartzJobScheduler.Object");
        Logger logger = (Logger)data.get((Object)"QuartzJobScheduler.Logger");
        try {
            logger.debug("Executing job {} with name {}", job, data.get((Object)"QuartzJobScheduler.JobName"));
            if (job instanceof Job) {
                Map configuration = (Map)data.get((Object)"QuartzJobScheduler.Configuration");
                String name = (String)data.get((Object)"QuartzJobScheduler.JobName");
                JobContextImpl jobCtx = new JobContextImpl(name, configuration);
                ((Job)job).execute(jobCtx);
            } else if (job instanceof Runnable) {
                ((Runnable)job).run();
            } else {
                logger.error("Scheduled job {} is neither a job nor a runnable.", job);
            }
        }
        catch (Throwable t) {
            if (t instanceof JobExecutionException) {
                throw (JobExecutionException)t;
            }
            logger.error("Exception during job execution of " + job + " : " + t.getMessage(), t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class JobContextImpl
    implements JobContext {
        protected final Map<String, Serializable> configuration;
        protected final String name;

        public JobContextImpl(String name, Map<String, Serializable> config) {
            this.name = name;
            this.configuration = config;
        }

        @Override
        public Map<String, Serializable> getConfiguration() {
            return this.configuration;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

